package core.control;

import edu.ucc.core.events.simulationevents.PushDataRequestEvent;
import edu.ucc.core.events.simulationevents.PushReason;
import edu.ucc.network.devices.Host;

/**
 * This class represents a message event that is pushed by the solution for disseminating status/control changes.
 * Notice objects of this class would be counted on the StatisticsCollector class.
 */
public final class PushMessageRequestEvent extends PushDataRequestEvent {
    public PushMessageRequestEvent(int appId, Host eventOriginHost, Host eventDestinationHost, double timestamp,
                                   MessageData pushedData, Host pushInitiatorHost, Host pushDestinationHost) {
        super(appId, eventOriginHost, eventDestinationHost, timestamp, pushedData,
                pushInitiatorHost, pushDestinationHost, PushReason.SYSTEM_RELATED);
    }

    @Override
    public MessageData getReferredContent() {
        return (MessageData) super.getReferredContent();
    }

    public String toString() {
        return String.format("[PushMessageRequestEvent] From %s %s to %s %s regarding %s @%s",
                pushInitiatorHost.getTypeAsString(), pushInitiatorHost.getId(),
                pushDestinationHost.getTypeAsString(), pushDestinationHost.getId(),
                referredContent.getDescription(), timestamp
        );
    }
}
