package core.control;

import core.Solution;
import edu.ucc.core.events.simulationevents.SimulationEvent;

public class ContentManagementEvent extends SimulationEvent {
    private final Solution solution;

    public ContentManagementEvent(Solution solution, double timestamp) {
        super(timestamp);
        this.solution = solution;
    }

    @Override
    public String toString() {
        return String.format("[ContentLifecycleManagement Event @%s]", timestamp);
    }

    @Override
    public void execute() {
        solution.handleContentLifeCycle();
    }
}
