package core.control;

import core.processingchain.events.ApplicationEvent;

public class AppMessageData extends MessageData {
    private final ApplicationEvent appEvent;

    public AppMessageData(long size, double timestamp, ApplicationEvent appEvent) {
        super(size, timestamp);
        this.appEvent = appEvent;
    }

    @Override
    public String getDescription() {
        return String.format("App message data with app event %s", appEvent);
    }

    public ApplicationEvent getAppEvent() {
        return appEvent;
    }
}
