package workload.mobility;

import edu.ucc.network.devices.BaseStation;
import edu.ucc.network.devices.UserEquipment;

import java.util.*;

public class UserEquipmentsPerBsScoreboard {
    // the index is the id of the BS, the value is the list of currently associated UEs
    private Map<BaseStation, List<UserEquipment>> associatedUserEquipments;

    public UserEquipmentsPerBsScoreboard() {
        this.associatedUserEquipments = new HashMap<>();
    }

    /***
     * Gets all of the user equipments that are associated with the specified baseStation
     * @param baseStation The baseStation to look for.
     * @return The list of associated user equipments. An empty list if no one is associated with such baseStation.
     */
    public List<UserEquipment> getUEsAssociatedWithBaseStation(BaseStation baseStation) {
        List<UserEquipment> uesAssociatedToBS = associatedUserEquipments.get(baseStation);
        if (uesAssociatedToBS == null) {
            return new ArrayList<>();
        }
        return uesAssociatedToBS;
    }

    public void associateUserEquipment(BaseStation baseStation, UserEquipment userEquipment) {
        List<UserEquipment> userEquipments = getUEsAssociatedWithBaseStation(baseStation);
        userEquipments.add(userEquipment);
        associatedUserEquipments.put(baseStation, userEquipments);
    }

    public List<BaseStation> getBaseStationsWithUserEquipments() {
        final Set<BaseStation> baseStations = associatedUserEquipments.keySet();
        return new ArrayList<>(baseStations);
    }

}
