package workload.mobility;

import bonnmotion.models.RandomWaypoint;
import edu.ucc.workload.WorkloadGenerationConstants;

import java.io.IOException;
import java.util.List;

/***
 * This class is a wrapper for the generation of workload.mobility traces using a workload.mobility model from the BonnMotion prj.
 */
public class MobilityTraceGenerator {
    /***
     * The number of nodes (UEs).
     */
    private final int numUserEquipments;

    /***
     * The width of the map.
     */
    private final double mapWidth;

    /***
     * The depth of the map.
     */
    private final double mapHeight;

    /***
     * The time length of the workload.mobility traces to create.
     */
    private final double timeLength;

    /***
     * The minimum speed for the nodes (UEs).
     */
    private final double minSpeed;

    /***
     * The maximum speed for the nodes (UEs).
     */
    private final double maxSpeed;

    /***
     * The maximum pause for the nodes (UEs).
     */
    private final double maxPause;

    /***
     * Basic constructor
     * @param numUserEquipments Nodes to simulate.
     * @param mapWidth Width of the rectangular map.
     * @param mapHeight Height of the rectangular map.
     * @param timeLength The length of the trajectories (time).
     * @param minSpeed The minimum speed of the nodes (UEs).
     * @param maxSpeed The maximum speed of the nodes (UEs).
     * @param maxPause The maximum pause time of the nodes (UEs).
     */
    public MobilityTraceGenerator(int numUserEquipments, double mapWidth, double mapHeight, double timeLength, double minSpeed,
                                  double maxSpeed, double maxPause) {
        this.numUserEquipments = numUserEquipments;
        this.mapWidth = mapWidth;
        this.mapHeight = mapHeight;
        this.timeLength = timeLength;
        this.minSpeed = minSpeed;
        this.maxSpeed = maxSpeed;
        this.maxPause = maxPause;

    }

    /***
     * Launches the actual generation of the workload.mobility traces for each of the UEs.
     * @return The list of workload.mobility traces. See {@link MobilityTrace}
     */
    public List<workload.mobility.MobilityTrace> generateMobilityTraces() {
        final double mapHeight = 0.0;
        final double ignore = 3600; // seconds ignored from the beginning
        final long randomSeed = WorkloadGenerationConstants.RANDOM_SEED; // I suppose for reproducibility purposes
        final int dimensions = 3;
        RandomWaypoint rwp = new RandomWaypoint(numUserEquipments, mapWidth, this.mapHeight, mapHeight, timeLength, ignore, randomSeed, minSpeed, maxSpeed, maxPause, dimensions);
        try {
            rwp.write("C:\\Users\\Rafael\\Desktop\\traces");
        } catch (IOException e) {
            e.printStackTrace();
        }
        final MobilityMapper mobilityMapper = new MobilityMapper(rwp);
        return mobilityMapper.transformToTraces();
    }
}
