package workload.mobility;

public class MobilityParameters {
    private final double bsRange;
    private final double mapWidth;
    private final double mapHeight;
    private final int numEdgeServers;
    private int numUserEquipments;
    private final double trajectoryTime;
    private final double minSpeed;
    private final double maxSpeed;
    private final double maxPause;

    private boolean mobilityEnabled;

    public MobilityParameters(double bsRange, double mapWidth, double mapHeight, int numEdgeServers,
                              int numUserEquipments, double trajectoryTime, double minSpeed, double maxSpeed,
                              double maxPause) {
        this.bsRange = bsRange;
        this.mapWidth = mapWidth;
        this.mapHeight = mapHeight;
        this.numEdgeServers = numEdgeServers;
        this.numUserEquipments = numUserEquipments;
        this.trajectoryTime = trajectoryTime;
        this.minSpeed = minSpeed;
        this.maxSpeed = maxSpeed;
        this.maxPause = maxPause;
        this.mobilityEnabled = true;
    }

    public double getBsRange() {
        return bsRange;
    }

    public double getMapWidth() {
        return mapWidth;
    }

    public double getMapHeight() {
        return mapHeight;
    }

    public int getNumEdgeServers() {
        return numEdgeServers;
    }

    public int getNumUserEquipments() {
        return numUserEquipments;
    }

    public double getTrajectoryTime() {
        return trajectoryTime;
    }

    public double getMinSpeed() {
        return minSpeed;
    }

    public double getMaxSpeed() {
        return maxSpeed;
    }

    public double getMaxPause() {
        return maxPause;
    }

    public void setNumUserEquipments(int numUserEquipments) {
        this.numUserEquipments = numUserEquipments;
    }

    /**
     * Control whether mobility events will be produced by the mobility generator. If it is set to false,
     * only the initial locations will be generated.
     *
     * @param mobilityEnabled true to generate mobility events, false otherwise
     */
    public void setMobilityEnabled(boolean mobilityEnabled) {
        this.mobilityEnabled = mobilityEnabled;
    }

    public boolean isMobilityEnabled() {
        return mobilityEnabled;
    }
}
