package utils;

import bonnmotion.models.RandomWaypoint;
import edu.ucc.network.devices.LocationFix;
import workload.mobility.MobilityMapper;
import workload.mobility.MobilityTrace;

import java.util.List;

public class IntegratingBonnMotion {
    public static void main(String[] args) {
        final int nodes = 10;
        final double mapWidth = 10., mapDepth = 10., mapHeight = 0;
        final double trajectoryTimeLength = 300; // one hour I presume
        final double ignore = 0; // We will ignore 0 seconds from the
        final long randomSeed = 123456L; // I suppose for reproducibility purposes
        final double minSpeed = 0;
        final double maxSpeed = 2; // lets try to focus on pedestrians
        final double maxPause = 60; // maximum pause is one minute
        final int dimensions = 2;
        RandomWaypoint rwp = new RandomWaypoint(nodes, mapWidth, mapDepth, mapHeight, trajectoryTimeLength, ignore, randomSeed, minSpeed, maxSpeed, maxPause, dimensions);
        // final MobileNode[] theNodes = rwp.getScenarioParameters().nodes;

        //        for (int i = 0; i < theNodes.length; i++) {
        //            final MobileNode node = theNodes[i];
        //            System.out.println(String.format("Trace for ue %s", i));
        //            for (int j = 0; j < node.getWaypoints().size(); j++) {
        //                final Waypoint waypoint = node.getWaypoints().get(j);
        //
        //                System.out.println(String.format("(%s, %s @ %s)", waypoint.pos.mapWidth, waypoint.pos.mapDepth, waypoint.time));
        //            }
        //        }

        final MobilityMapper mobilityMapper = new MobilityMapper(rwp);
        final List<MobilityTrace> mobilityTraces = mobilityMapper.transformToTraces();
        for (MobilityTrace mobilityTrace : mobilityTraces) {
            System.out.println(String.format("Trace for ue %s", mobilityTrace.getUserEquipmentId()));
            final List<LocationFix> fixes = mobilityTrace.getLocationFixes();
            for (LocationFix fix : fixes) {
                System.out.println(String.format("%s", fix));
            }

        }
    }
}
