package sampleapps.platerecognition;

import core.app.App;
import core.processingchain.metadata.pool.BaseMetadata;
import core.processingchain.preprocessors.PPOutcome;
import core.processingchain.preprocessors.PreProcessor;
import edu.ucc.core.events.simulationevents.ContentReceivedEvent;

import static edu.ucc.utils.Logging.printInfo;

public class PreProcessorPlateRecognition extends PreProcessor<ContentReceivedEvent> {
    @Override
    public PPOutcome execute(App app, ContentReceivedEvent inputSolutionEvent, BaseMetadata metadata, double timestamp) {
        // A constant for preprocessing delay for push requests
        double preprocessingDelay = 0.00015;
        double preProcessingTimestamp = preprocessingDelay + timestamp; //inputSolutionEvent.getTimestamp();
        final PPOutcomePlateRecognition ppOutcome = new PPOutcomePlateRecognition(app.getAppId(),
                "Outcome of preprocessing module for car plate number recognition app.",
                preProcessingTimestamp, metadata, inputSolutionEvent);

        printInfo(String.format("Preprocessed %s for car plate number recognition app (appId: %s) @ %s",
                inputSolutionEvent.getReferredContent(), app.getAppId(), ppOutcome.getTimestamp()));
        return ppOutcome;
    }
}
