package sampleapps.platerecognition;

import core.context.ContextAPI;
import core.processingchain.events.detectors.BaseEventDetector;
import edu.ucc.network.devices.Host;

import java.util.Random;

import static edu.ucc.utils.Logging.printInfo;

public class EventDetectorPlateRecognition extends BaseEventDetector<PPOutcomePlateRecognition> {
    @Override
    public PlateRecognitionEvent execute(ContextAPI contextAPI, Host localHost, PPOutcomePlateRecognition ppOutcome) {
        double eventDetectionDelay = 0.00015;
        Random random = new Random(System.currentTimeMillis());
        String detectedCarPlateNumber = String.valueOf(random.nextInt(2) + 1) +
                random.nextInt(10) +
                1 +
                (char) (random.nextInt(26) + 'A') +
                random.nextInt(10) +
                random.nextInt(10) +
                random.nextInt(10) +
                random.nextInt(10) +
                random.nextInt(10) +
                random.nextInt(10);

        final PlateRecognitionEvent plateRecognitionEvent = new PlateRecognitionEvent(
                ppOutcome.getAppId(),
                localHost,
                ppOutcome,
                null,
                ppOutcome.getTimestamp() + eventDetectionDelay,
                detectedCarPlateNumber
        );
        printInfo(String.format("PlateRecognitionEvent: %s in %s %s at %s",
                plateRecognitionEvent.getDetectedCarPlateNumber(),
                plateRecognitionEvent.getDetectingHost().getTypeAsString(),
                plateRecognitionEvent.getDetectingHost().getId(),
                plateRecognitionEvent.getTimestamp()));
        return plateRecognitionEvent;
    }
}
