package sampleapps.platerecognition;

import edu.ucc.entities.IoTData;
import edu.ucc.entities.IoTDataType;
import edu.ucc.network.devices.Location;
import edu.ucc.network.devices.UserEquipment;

public class CameraData extends IoTData {
    private final int height;
    private final int width;
    private final float resolution;
    private final Location location;

    public CameraData(long size, UserEquipment dataSourceUE, double timestamp, int height, int width, float resolution, Location location) {
        super(size, dataSourceUE, IoTDataType.IMAGE, timestamp);
        this.height = height;
        this.width = width;
        this.resolution = resolution;
        this.location = location;
    }

    public int getHeight() {
        return height;
    }

    public int getWidth() {
        return width;
    }

    public float getResolution() {
        return resolution;
    }

    public Location getLocation() {
        return location;
    }
}
