package loader;

import edu.ucc.network.architecture.ArchitectureParameters;
import workload.mobility.MobilityParameters;
import workload.requests.ContentRequestParameters;

import java.util.Map;


public class SystemLoader extends AbstractSystemLoader {
    public SystemLoader(ArchitectureParameters architectureParameters, MobilityParameters mobilityParameters,
                        Map<Integer, ContentRequestParameters> contentParametersPerApp) {
        super(architectureParameters, mobilityParameters, contentParametersPerApp);

    }

    @Override
    public void loadSystem() {
        generateArchitecture();
        generateMobility();
        setInitialUserEquipmentsLocation();
        linkUserEquipmentsWithBaseStations();
        createRoutingTable();
        generateRequests();
        loadWorkloadEvents();
    }
}
