package integrationtests.tests.sysloaders;

import edu.ucc.core.events.simulationevents.*;
import edu.ucc.entities.File;
import edu.ucc.entities.IoTData;
import edu.ucc.entities.IoTDataType;
import edu.ucc.network.devices.*;
import edu.ucc.workload.Workload;
import sampleapps.platerecognition.CameraData;

import java.util.ArrayList;
import java.util.List;

import static edu.ucc.utils.FileConstants.KILOBYTE;
import static edu.ucc.utils.FileConstants.MEGABYTE;

public class WorkloadGeneratorFactory {
    public static ICustomWorkloadGenerator workloadHighPopularityDownlinkScenario() {
        return (networkArchitecture, workload, mobilityEvents, generatedFiles) -> {
            List<RequestEvent> requestEvents = new ArrayList<>();
            double timestamp = 60;
            UserEquipment userEquipment = networkArchitecture.getUserEquipments().get(1);
            final CloudUnit cloud = networkArchitecture.getCloudRoot();
            File file = generatedFiles.get(0);
            for (int i = 0; i < 3; i++) {
                requestEvents.add(new PullFileRequestEvent(1, null, userEquipment, timestamp, userEquipment, cloud, file));
                timestamp += 60;
            }

            workload.setRequestEvents(1, requestEvents);
            workload.setMobilityEvents(new ArrayList<>());
            workload.setFilesUniverse(generatedFiles);
        };
    }

    public static ICustomWorkloadGenerator workloadHighPopularityUplinkScenario() {
        return (networkArchitecture, workload, mobilityEvents, generatedFiles) -> {
            List<RequestEvent> requestEvents = new ArrayList<>();
            double timestamp = 60;
            // Let's say the Host that requests is the cloud.
            // And it will request for data that is in the userEquipment with id 1
            UserEquipment userEquipment = networkArchitecture.getUserEquipments().get(1);
            final CloudUnit cloud = networkArchitecture.getCloudRoot();
            for (int i = 0; i < 3; i++) {
                IoTData data = new IoTData(1200, userEquipment, IoTDataType.SPEED, timestamp);
                requestEvents.add(new PullDataRequestEvent(1, null, cloud, timestamp, cloud, userEquipment, data));
                timestamp += 60;
            }

            workload.setRequestEvents(1, requestEvents);
            workload.setMobilityEvents(new ArrayList<>());
            workload.setFilesUniverse(generatedFiles);
        };
    }

    public static ICustomWorkloadGenerator workloadHighThenLowPopularityDownlink() {
        return (networkArchitecture, workload, mobilityEvents, generatedFiles) -> {
            List<RequestEvent> requestEvents = new ArrayList<>();
            double timestamp = 60;
            UserEquipment userEquipment = networkArchitecture.getUserEquipments().get(1);
            final CloudUnit cloud = networkArchitecture.getCloudRoot();

            // First, make a file popular, so it is stored with reason: "popularity".
            File file = generatedFiles.get(0);
            for (int i = 0; i < 3; i++) {
                requestEvents.add(new PullFileRequestEvent(1, null, userEquipment, timestamp, userEquipment, cloud, file));
                timestamp += 60;
            }

            // then, then fill the remaining space with different files
            for (int i = 1; i < 9; i++) {
                file = generatedFiles.get(i);
                requestEvents.add(new PullFileRequestEvent(1, null, userEquipment, timestamp, userEquipment, cloud, file));
                timestamp += 60;
            }

            // At this point, the storage could be exhausted,
            // so we create a request for another file to see how one of the not popular files is deleted.
            file = generatedFiles.get(generatedFiles.size() - 1); // we get the las file here.
            requestEvents.add(new PullFileRequestEvent(1, null, userEquipment, timestamp, userEquipment, cloud, file));
            timestamp += 60;
            requestEvents.add(new PullFileRequestEvent(1, null, userEquipment, timestamp, userEquipment, cloud, file));
            timestamp += 60;
            requestEvents.add(new PullFileRequestEvent(1, null, userEquipment, timestamp, userEquipment, cloud, file));

            workload.setRequestEvents(1, requestEvents);
            workload.setMobilityEvents(new ArrayList<>());
            workload.setFilesUniverse(generatedFiles);
        };
    }

    public static ICustomWorkloadGenerator workloadHighPopularityDownlinkForControlMessagesScenario() {
        return (networkArchitecture, workload, mobilityEvents, generatedFiles) -> {
            List<RequestEvent> requestEvents = new ArrayList<>();
            double timestamp = 60;
            UserEquipment userEquipment = networkArchitecture.getUserEquipments().get(1);
            final CloudUnit cloud = networkArchitecture.getCloudRoot();
            File file = generatedFiles.get(0);
            for (int i = 0; i < 3; i++) {
                requestEvents.add(new PullFileRequestEvent(1, null, userEquipment, timestamp, userEquipment, cloud, file));
                timestamp += 60;
            }

            workload.setRequestEvents(1, requestEvents);
            workload.setMobilityEvents(new ArrayList<>());
            workload.setFilesUniverse(generatedFiles);
        };
    }

    public static ICustomWorkloadGenerator workloadEmpty() {
        return (networkArchitecture, workload, mobilityEvents, generatedFiles) -> {
            workload.setRequestEvents(1, new ArrayList<>());
            workload.setMobilityEvents(new ArrayList<>());
            workload.setFilesUniverse(new ArrayList<>());
        };
    }

    public static ICustomWorkloadGenerator workloadForStorageAllocation() {
        return (networkArchitecture, workload, mobilityEvents, generatedFiles) -> {
            List<RequestEvent> requestEvents = new ArrayList<>();
            double timestamp = 60;
            UserEquipment userEquipment = networkArchitecture.getUserEquipments().get(1);
            final CloudUnit cloud = networkArchitecture.getCloudRoot();
            File file = generatedFiles.get(0);
            for (int i = 0; i < 3; i++) {
                requestEvents.add(new PullFileRequestEvent(1, null, userEquipment, timestamp, userEquipment, cloud, file));
                timestamp += 60;
            }

            file = generatedFiles.get(1);
            //  If you use this, the app is not running at that es1 so no pop is found userEquipment = networkArchitecture.getUserEquipments().get(20);
            userEquipment = networkArchitecture.getUserEquipments().get(75);
            for (int i = 0; i < 3; i++) {
                requestEvents.add(new PullFileRequestEvent(1, null, userEquipment, timestamp, userEquipment, cloud, file));
                timestamp += 60;
            }

            workload.setRequestEvents(1, requestEvents);
            workload.setMobilityEvents(new ArrayList<>());
            workload.setFilesUniverse(generatedFiles);
        };
        //        return (networkArchitecture, workload, mobilityEvents, generatedFiles) -> {
        //            List<RequestEvent> requestEvents = new ArrayList<>();
        //            double timestamp = 60;
        //            UserEquipment userEquipment = networkArchitecture.getUserEquipments().get(1);
        //            final CloudUnit cloud = networkArchitecture.getCloudRoot();
        //            File file = generatedFiles.get(0);
        //            for (int i = 0; i < 3; i++) {
        //                requestEvents.add(new PullFileRequestEvent(1, null, userEquipment, timestamp, userEquipment, cloud, file));
        //                timestamp += 60;
        //            }
        //
        //            file = generatedFiles.get(1);
        //            //  If you use this, the app is not running at that es1 so no pop is found userEquipment = networkArchitecture.getUserEquipments().get(20);
        //            userEquipment = networkArchitecture.getUserEquipments().get(75);
        //            for (int i = 0; i < 3; i++) {
        //                requestEvents.add(new PullFileRequestEvent(1, null, userEquipment, timestamp, userEquipment, cloud, file));
        //                timestamp += 60;
        //            }
        //
        //            workload.setRequestEvents(1, requestEvents);
        //            workload.setMobilityEvents(new ArrayList<>());
        //            workload.setFilesUniverse(generatedFiles);
        //        };
    }

    public static ICustomWorkloadGenerator workloadForAppNotDeployedAtServerScenario() {
        return (NetworkArchitecture networkArchitecture, Workload workload, List<HandoverEvent> mobilityEvents, List<File> generatedFiles) -> {
            List<RequestEvent> requestEvents = new ArrayList<>();
            UserEquipment userEquipment = networkArchitecture.getUserEquipments().get(79); // must be with id 79
            final int timestamp = 3600;
            IoTData cameraData = new CameraData(KILOBYTE, userEquipment, timestamp, 800, 600, 480, new Location(0, 0));

            //                requestEvents.add(new PullFileRequestEvent(1, null, userEquipment, timestamp, userEquipment, cloud, file));
            final Host edgeServer = userEquipment.getParentUnit().getParentUnit();
            requestEvents.add(new PushDataRequestEvent(1, null, userEquipment, timestamp, cameraData, userEquipment, edgeServer, PushReason.NORMAL_TRAFFIC));

            workload.setRequestEvents(1, requestEvents);
            workload.setMobilityEvents(new ArrayList<>());
            workload.setFilesUniverse(generatedFiles);
        };
    }

    /**
     * We use it to design/test the mobility events changes.
     *
     * @return
     */
    public static ICustomWorkloadGenerator workloadForTestingMobilityAwarePrefetching() {
        // Notice this short notation is returning an ICustomWorkloadGenerator reference with the lambda being the
        // generateRequestsForWorkload() method
        return (networkArchitecture, workload, mobilityEvents, generatedFiles) -> {
            final CloudUnit cloud = networkArchitecture.getCloudRoot();
            final Host prefetchInitiatorHost = cloud;
            final double eventTs = 1000;
            final double prefetchTimestamp = 23000;
            List<RequestEvent> events = new ArrayList<>();
            final File fileToPrefetch = new File("www.app1.com/filePrefetch.txt", MEGABYTE * 100);
            final int[] destinationUEs = {1};
            boolean targetingEdgeServers = false;
            events.add(new PrefetchRequestEvent(1, null, cloud, prefetchInitiatorHost, eventTs,
                    fileToPrefetch, destinationUEs, targetingEdgeServers, prefetchTimestamp));

            UserEquipment ue = networkArchitecture.getUserEquipments().get(1);
            final int reqTimestamp = 23010;
            events.add(new PullFileRequestEvent(1, null, ue, reqTimestamp, ue, cloud, fileToPrefetch));
            workload.setRequestEvents(1, events);

        };
    }

    public static ICustomWorkloadGenerator workloadForTestingDirectEdgeServerPrefetching() {
        return (networkArchitecture, workload, mobilityEvents, generatedFiles) -> {
            final CloudUnit cloud = networkArchitecture.getCloudRoot();
            final Host prefetchInitiatorHost = cloud;
            final double eventTs = 1000;
            final double prefetchTimestamp = 23000;
            List<RequestEvent> events = new ArrayList<>();
            final File fileToPrefetch = new File("www.app1.com/filePrefetch.txt", MEGABYTE * 100);
            final int[] destinationESs = {0, 1};
            boolean targetingEdgeServers = true;
            events.add(new PrefetchRequestEvent(1, null, cloud, prefetchInitiatorHost, eventTs,
                    fileToPrefetch, destinationESs, targetingEdgeServers, prefetchTimestamp));

            workload.setRequestEvents(1, events);
        };
    }
}
