package integrationtests.tests;

import core.Solution;
import core.app.App;
import core.processingchain.actions.policies.pool.PushPolicy;
import core.processingchain.actions.pool.PushAction;
import core.processingchain.actions.pool.StoreAction;
import core.processingchain.events.detectors.pool.popularity.PopularityEventDetector;
import core.processingchain.events.pool.HighPopularityEvent;
import core.processingchain.events.pool.PopularityEvent;
import core.processingchain.metadata.MetadataType;
import core.processingchain.metadata.extractor.MetadataExtractor;
import core.processingchain.metadata.pool.BaseMetadata;
import core.processingchain.metadata.pool.PopularityEventMetadata;
import core.processingchain.preprocessors.pool.PPOutcomePullRequest;
import edu.ucc.core.Simulation;
import edu.ucc.network.architecture.ArchitectureParameters;
import edu.ucc.network.devices.EdgeServer;
import edu.ucc.utils.FileConstants;
import edu.ucc.utils.Logging;
import edu.ucc.utils.TimeConstants;
import integrationtests.tests.sysloaders.CustomWorkloadSystemLoader;
import integrationtests.tests.sysloaders.ICustomWorkloadGenerator;
import integrationtests.tests.sysloaders.WorkloadGeneratorFactory;
import loader.AbstractSystemLoader;
import org.junit.jupiter.api.Test;
import workload.mobility.MobilityParameters;
import workload.requests.ContentRequestParameters;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import static edu.ucc.utils.FileConstants.KILOBYTE;
import static org.junit.jupiter.api.Assertions.assertTrue;
import static utils.ScenarioConstants.TRAJECTORY_TIME;
import static utils.Utils.createGenericArchitectureParameters;
import static utils.Utils.createGenericMobilityParameters;

class ScenarioHighPopularityUplinkTest {

    @Test
    void executeTestForScenario() {
        // What should I see here:
        // 1. Data is popular in the first wave after the third download as the threshold is set as 3
        // we should also see that the file downloaded exists in the file system after the execution and that it is pushed
        // to other ess as well.
        App app = new App(1, "app1", "www.app1.com/", 512 * FileConstants.GIGABYTE);
        app.addEventDetector(PPOutcomePullRequest.class, new PopularityEventDetector(TimeConstants.HOUR, 3));
        app.addMetadataExtractor(MetadataType.INTERNAL_EVENT_METADATA, new MetadataExtractor<PopularityEvent>() {
            @Override
            public BaseMetadata extractMetadata(PopularityEvent hpEvent) {
                boolean highPopularity = hpEvent instanceof HighPopularityEvent;
                return new PopularityEventMetadata(hpEvent.getAppId(), hpEvent.getTestbedEvent(), highPopularity);
            }
        });
        app.addActionForEventType(HighPopularityEvent.class, new StoreAction());
        app.addActionForEventType(HighPopularityEvent.class, new PushAction());
        app.setPolicyForActionType(PushAction.class, new PushPolicy(false, true, false));
        app.setOpportunisticStorage(true);

        Simulation simulation = executeScenario(app, WorkloadGeneratorFactory.workloadHighPopularityUplinkScenario());

        final List<EdgeServer> edgeServers = simulation.getNetworkArchitecture().getEdgeServers();
        final EdgeServer es0 = edgeServers.get(0);
        final EdgeServer es1 = edgeServers.get(1);

        assertTrue(es0.getFileSystem().contentExists("Cloud/ES0/BS9/UE1/speed"));
        // NOTICE: THIS TEST IS FAILING BECAUSE NOW WE LOOK FOR POPULARITY USING CONTENT ID RATHER THAN URL. SINCE THE ID
        // OF GENERATED DATA IS DIFFERENT, THEN WE DON'T FIND POPULARITY FOR THE SAME CONTENT...
        assertTrue(es1.getFileSystem().contentExists("Cloud/ES0/BS9/UE1/speed"));
    }

    private Simulation executeScenario(App app, ICustomWorkloadGenerator workloadGenerator) {
        ArchitectureParameters architectureParameters = createGenericArchitectureParameters();
        MobilityParameters mobilityParameters = createGenericMobilityParameters();

        final ContentRequestParameters contentRequestParametersForAppUplink = createContentParametersForAppUplink(mobilityParameters.getTrajectoryTime());

        Map<Integer, ContentRequestParameters> parametersPerApp = new HashMap<>();
        parametersPerApp.put(1, contentRequestParametersForAppUplink);

        AbstractSystemLoader systemLoader = new CustomWorkloadSystemLoader(architectureParameters,
                mobilityParameters,
                parametersPerApp, workloadGenerator);

        systemLoader.loadSystem();
        final Solution solution = new Solution(systemLoader.getNetworkArchitecture());

        solution.registerApp(app);

        Logging.configureLogging(Logging.WARNING | Logging.CONTENT_RECEIVED | Logging.INFO | Logging.PULL_DATA_REQUEST);
        final Simulation simulation = Simulation.getInstance();

        simulation.init(systemLoader.getNetworkArchitecture(), systemLoader.getWorkload(), solution, TRAJECTORY_TIME);
        simulation.startSimulation();
        simulation.restart();
        return simulation;
    }

    private ContentRequestParameters createContentParametersForAppUplink(double requestEndTime) {
        // This is for pull workload.requests
        final int numFileRequests = 0;
        final int numOfFiles = 0;
        final long minFileSize = 99 * FileConstants.MEGABYTE;
        final long maxFileSize = 99 * FileConstants.MEGABYTE; // 2 * MEGABYTE;

        final int numPullDataRequests = 5;
        final long minDataSizeInPullDataRequests = KILOBYTE;
        final long maxDataSizeInPullDataRequests = 2 * KILOBYTE;


        // This is for push workload.requests
        final int numPushDataRequests = 0;
        final long minDataSizeInPushDataRequests = 0;
        final long maxDataSizeInPushDataRequests = 0;
        return new ContentRequestParameters(1,
                "www.app1.com/",
                numFileRequests,
                numOfFiles,
                minFileSize,
                maxFileSize,
                numPullDataRequests,
                minDataSizeInPullDataRequests,
                maxDataSizeInPullDataRequests,
                numPushDataRequests,
                minDataSizeInPushDataRequests,
                maxDataSizeInPushDataRequests,
                0.0, requestEndTime);
    }
}