/*
 * Decompiled with CFR 0.152.
 */
package main;

import bonnmotion.App;
import bonnmotion.Model;
import bonnmotion.ModuleInfo;

public class Main {
    private static final String PROG_NAME = "BonnMotion";
    private static final String PROG_VER = "3.0.1";
    private static final String MODELS_PACK = "edu.bonn.cs.iv.bonnmotion.models";
    private static final String[] MODELS = new String[]{"Boundless", "ChainScenario", "Column", "DisasterArea", "GaussMarkov", "ManhattanGrid", "MSLAW", "Nomadic", "OriginalGaussMarkov", "ProbRandomWalk", "Pursue", "RandomDirection", "RandomStreet", "RandomWalk", "RandomWaypoint", "RPGM", "SLAW", "SMOOTH", "Static", "StaticDrift", "SteadyStateRandomWaypoint", "SWIM", "TIMM", "TLW"};
    private static final String APPS_PACK = "edu.bonn.cs.iv.bonnmotion.apps";
    private static final String[] APPS = new String[]{"Cut", "CSVFile", "Dwelltime", "GlomoFile", "GPXImport", "InRangePrinter", "IntervalFormat", "LinkDump", "LongestLink", "NSFile", "SPPXml", "Statistics", "TheONEFile", "Visplot", "WiseML"};
    private String fSettings = null;
    private String fSaveScenario = null;

    public static Class<?> str2class(String _class) {
        Class<?> result = null;
        try {
            int i;
            for (i = 0; i < MODELS.length; ++i) {
                if (!MODELS[i].equals(_class)) continue;
                result = Class.forName("edu.bonn.cs.iv.bonnmotion.models." + _class);
            }
            for (i = 0; i < APPS.length; ++i) {
                if (!APPS[i].equals(_class)) continue;
                result = Class.forName("edu.bonn.cs.iv.bonnmotion.apps." + _class);
            }
            if (result == null) {
                throw new RuntimeException("Unknown Module " + _class);
            }
        }
        catch (Exception e) {
            App.exceptionHandler("Error in BM ", e);
        }
        return result;
    }

    private void printRuntime(long start_time, long stop_time) {
        int hours;
        int minutes;
        int seconds = (int)(stop_time - start_time);
        String timestr = "";
        timestr = seconds < 60 ? String.format("%d sec", seconds) : ((minutes = seconds / 60) < 60 ? String.format("%d min %d sec", minutes, seconds % 60) : ((hours = minutes / 60) == 1 ? String.format("%d hour %d min %d sec", hours, minutes % 60, seconds % 60) : String.format("%d hours %d min %d sec", hours, minutes % 60, seconds % 60)));
        System.out.println("Runtime: " + timestr);
    }

    private void printHeader() {
        System.out.println("BonnMotion 3.0.1\n");
        System.out.println("OS: " + System.getProperty("os.name") + " " + System.getProperty("os.version"));
        System.out.println("Java: " + System.getProperty("java.vendor") + " " + System.getProperty("java.version") + "\n\n");
    }

    private void printModels() {
        System.out.println("Available models: ");
        for (int i = 0; i < MODELS.length; ++i) {
            Class<?> c = Main.str2class(MODELS[i]);
            ModuleInfo result = null;
            try {
                result = (ModuleInfo)c.getMethod("getInfo", null).invoke(null, (Object[])null);
            }
            catch (Exception e) {
                System.err.println("could not retrieve module info from " + c.getCanonicalName());
            }
            if (result == null) continue;
            System.out.println(result.toShortString());
        }
    }

    private void printApps() {
        System.out.println("Available apps: ");
        for (int i = 0; i < APPS.length; ++i) {
            Class<?> c = Main.str2class(APPS[i]);
            ModuleInfo result = null;
            try {
                result = (ModuleInfo)c.getMethod("getInfo", null).invoke(null, (Object[])null);
            }
            catch (Exception e) {
                System.err.println("could not retrieve module info from " + c.getCanonicalName());
            }
            if (result == null) continue;
            System.out.println(result.toShortString());
        }
    }

    private void printSpecificHelp(String _m) {
        Class<?> c = Main.str2class(_m);
        try {
            c.getMethod("printHelp", null).invoke(null, (Object[])null);
        }
        catch (Exception e) {
            App.exceptionHandler("could not print help to " + c, e);
        }
    }

    public static void printHelp() {
        System.out.println("Help:");
        System.out.println("  -h                    \tPrint this help");
        System.out.println("");
        System.out.println("Scenario generation:");
        System.out.println("  -f <scenario name> [-I <parameter file>] <model name> [model options]");
        System.out.println("  -hm                           Print available models");
        System.out.println("  -hm <module name>             Print help to specific model");
        System.out.println("");
        System.out.println("Application:");
        System.out.println("  <application name> [Application-Options]");
        System.out.println("  -ha                           Print available applications");
        System.out.println("  -ha <application name>        Print help to specific application");
    }

    protected boolean parseArg(char key, String val) {
        switch (key) {
            case 'I': {
                this.fSettings = val;
                return true;
            }
            case 'f': {
                this.fSaveScenario = val;
                return true;
            }
        }
        return false;
    }

    public void go(String[] _args) throws Throwable {
        this.printHeader();
        if (_args.length == 0) {
            Main.printHelp();
        } else if (_args[0].equals("-h")) {
            Main.printHelp();
        } else if (_args[0].equals("-hm")) {
            if (_args.length > 1) {
                this.printSpecificHelp(_args[1]);
            } else {
                this.printModels();
            }
        } else if (_args[0].equals("-ha")) {
            if (_args.length > 1) {
                this.printSpecificHelp(_args[1]);
            } else {
                this.printApps();
            }
        } else {
            int pos;
            for (pos = 0; _args[pos].charAt(0) == '-' || pos == _args.length; ++pos) {
                String value;
                char key = _args[pos].charAt(1);
                if (this.parseArg(key, value = _args[pos].length() > 2 ? _args[pos].substring(2) : _args[++pos])) continue;
                System.out.println("warning: ignoring unknown key " + key);
            }
            System.out.println("Starting " + _args[pos] + " ...");
            long start_time = System.currentTimeMillis() / 1000L;
            Class<?> c = Main.str2class(_args[pos]);
            try {
                String[] args;
                if (c.getPackage().getName().startsWith(MODELS_PACK)) {
                    if (this.fSaveScenario == null) {
                        System.out.println("Refusing to create a scenario which will not be saved anyhow. (Use -f.)");
                        System.exit(0);
                    }
                    args = Main.removeFirstElements(_args, pos);
                    args[0] = this.fSettings;
                    Class[] cType = new Class[]{String[].class};
                    Object[] cParam = new Object[]{args};
                    ((Model)c.getConstructor(cType).newInstance(cParam)).write(this.fSaveScenario);
                } else {
                    args = Main.removeFirstElements(_args, pos + 1);
                    Class[] cType = new Class[]{String[].class};
                    Object[] cParam = new Object[]{args};
                    c.getConstructor(cType).newInstance(cParam);
                }
            }
            catch (ClassCastException e1) {
                System.out.println("ClassCastException");
            }
            catch (Exception e) {
                e.printStackTrace();
                App.exceptionHandler("Error in " + _args[pos], e);
            }
            System.out.println(_args[pos] + " done.");
            long stop_time = System.currentTimeMillis() / 1000L;
            this.printRuntime(start_time, stop_time);
        }
    }

    public static String[] removeFirstElements(String[] array, int n) {
        String[] r = new String[array.length - n];
        System.arraycopy(array, n, r, 0, r.length);
        return r;
    }

    public static void main(String[] args) throws Throwable {
        new Main().go(args);
    }
}

