/*
 * Decompiled with CFR 0.152.
 */
package bonnmotion;

import bonnmotion.Scenario;
import java.io.FileNotFoundException;
import java.io.IOException;

public abstract class RandomSpeedBase
extends Scenario {
    protected double minspeed = 0.5;
    protected double maxspeed = 1.5;
    protected double maxpause = 60.0;

    public RandomSpeedBase(int nodes, double x, double y, double duration, double ignore, long randomSeed, double minspeed, double maxspeed, double maxpause) {
        this(nodes, x, y, 0.0, duration, ignore, randomSeed, minspeed, maxspeed, maxpause);
    }

    public RandomSpeedBase(int nodes, double x, double y, double z, double duration, double ignore, long randomSeed, double minspeed, double maxspeed, double maxpause) {
        super(nodes, x, y, z, duration, ignore, randomSeed);
        this.minspeed = minspeed;
        this.maxspeed = maxspeed;
        this.maxpause = maxpause;
    }

    public RandomSpeedBase() {
    }

    public void write(String basename, String[] params) throws FileNotFoundException, IOException {
        String[] p = new String[]{"minspeed=" + this.minspeed, "maxspeed=" + this.maxspeed, "maxpause=" + this.maxpause};
        super.writeParametersAndMovement(basename, RandomSpeedBase.stringArrayConcat(params, p));
    }

    @Override
    protected boolean parseArg(char key, String val) {
        switch (key) {
            case 'h': {
                this.maxspeed = Double.parseDouble(val);
                return true;
            }
            case 'l': {
                this.minspeed = Double.parseDouble(val);
                return true;
            }
            case 'p': {
                this.maxpause = Double.parseDouble(val);
                return true;
            }
        }
        return super.parseArg(key, val);
    }

    @Override
    protected boolean parseArg(String key, String val) {
        if (key.equals("minspeed")) {
            this.minspeed = Double.parseDouble(val);
            return true;
        }
        if (key.equals("maxspeed")) {
            this.maxspeed = Double.parseDouble(val);
            return true;
        }
        if (key.equals("maxpause")) {
            this.maxpause = Double.parseDouble(val);
            return true;
        }
        return super.parseArg(key, val);
    }

    public static void printHelp() {
        Scenario.printHelp();
        System.out.println("RandomSpeedBase:");
        System.out.println("\t-h <max. speed>");
        System.out.println("\t-l <min. speed>");
        System.out.println("\t-p <max. pause time>");
    }
}

