/*
 * Decompiled with CFR 0.152.
 */
package bonnmotion;

import bonnmotion.Dimension;
import bonnmotion.MobileNode;
import bonnmotion.ParameterParser;
import bonnmotion.Position;
import bonnmotion.PrinterStyle;
import bonnmotion.ScenarioParameters;
import bonnmotion.Waypoint;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.zip.GZIPOutputStream;

public class Printer {
    PrinterStyle ps = null;
    Dimension dim = null;

    public Printer() {
        this(PrinterStyle.MovementString, Dimension.TWOD);
    }

    public Printer(Dimension dim) {
        this(PrinterStyle.MovementString, dim);
    }

    public Printer(PrinterStyle printerStyle, Dimension dim) {
        this.ps = printerStyle;
        this.dim = dim;
    }

    public String print(MobileNode mn) {
        if (this.ps == PrinterStyle.MovementString) {
            int waypointCount = mn.getNumWaypoints();
            StringBuffer sb = new StringBuffer(100 * waypointCount);
            for (int i = 0; i < waypointCount; ++i) {
                Waypoint w = mn.getWaypoint(i);
                sb.append(" ");
                sb.append(this.print(w));
            }
            sb.deleteCharAt(0);
            return sb.toString();
        }
        return "";
    }

    public String print(Waypoint w) {
        if (this.ps == PrinterStyle.MovementString) {
            StringBuilder sb = new StringBuilder();
            sb.append(w.time);
            sb.append(" ");
            sb.append(this.print(w.pos));
            return sb.toString();
        }
        return "";
    }

    public String print(Position pos) {
        if (this.ps == PrinterStyle.MovementString) {
            StringBuilder sb = new StringBuilder();
            sb.append(pos.x);
            sb.append(" ");
            sb.append(pos.y);
            if (this.dim == Dimension.THREED) {
                sb.append(" ");
                sb.append(pos.z);
            }
            return sb.toString();
        }
        return "";
    }

    public String movementStringDisasterArea(MobileNode node) {
        StringBuffer buffer = new StringBuffer(140 * node.getNumWaypoints());
        for (int i = 0; i < node.getNumWaypoints(); ++i) {
            Waypoint point = node.getWaypoint(i);
            buffer.append("\n");
            buffer.append(point.time);
            buffer.append("\n");
            buffer.append(point.pos.x);
            buffer.append("\n");
            buffer.append(point.pos.y);
            buffer.append("\n");
            buffer.append(point.pos.status);
        }
        buffer.deleteCharAt(0);
        return buffer.toString();
    }

    public void writeOutsourced(String basename, ScenarioParameters baseParameters, String[] additionalParameters) throws FileNotFoundException, IOException {
        PrintWriter parameterWriter = new PrintWriter(new FileOutputStream(basename + ".params"));
        ParameterParser parser = new ParameterParser();
        parameterWriter.println(parser.scenarioParser(baseParameters));
        if (additionalParameters != null) {
            parameterWriter.println(parser.additionalParameterParser(additionalParameters));
        }
        if (baseParameters.aFieldParams != null) {
            parameterWriter.println(parser.attractorFieldParser(baseParameters));
        }
        parameterWriter.close();
        PrintWriter movementWriter = new PrintWriter(new GZIPOutputStream(new FileOutputStream(basename + ".movements.gz")));
        if (baseParameters.outputDim == Dimension.THREED) {
            movementWriter.println("#3D");
        }
        for (int i = 0; i < baseParameters.nodes.length; ++i) {
            if (baseParameters.modelName.equals("DisasterArea")) {
                movementWriter.println(this.movementStringDisasterArea(baseParameters.nodes[i]));
                continue;
            }
            movementWriter.println(this.print(baseParameters.nodes[i]));
        }
        movementWriter.close();
    }
}

