/*
 * Decompiled with CFR 0.152.
 */
package bonnmotion;

import bonnmotion.CatastropheArea;
import bonnmotion.CatastropheNode;
import bonnmotion.IntegerHashMap;
import bonnmotion.ModuleInfo;
import bonnmotion.Obstacle;
import bonnmotion.Position;
import bonnmotion.PositionHashMap;
import bonnmotion.RandomSpeedBase;
import java.awt.Rectangle;
import java.awt.geom.Line2D;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.Map;
import java.util.Vector;

public class DisasterArea
extends RandomSpeedBase {
    private static ModuleInfo info = new ModuleInfo("DisasterArea");
    private static boolean debug;
    protected double maxdist = 2.5;
    protected double mindist = 2.5;
    protected double avgMobileNodesPerGroup = 3.0;
    protected double groupSizeDeviation = 0.0;
    protected double pGroupChange = 0.0;
    protected int groups = 0;
    protected int maxGroupSize = 0;
    protected int numCatastropheAreas = 0;
    protected int maxCatastropheAreas = 4;
    protected boolean onlyOneObstacle = false;
    protected boolean addObsT4 = false;
    protected CatastropheArea[] catastropheAreas = null;
    private LinkedList<String> catastropheAreaArgs = new LinkedList();
    Position dst = new Position(0.0, 0.0);
    double oldmaxpause = 0.0;
    double oldmaxdist = 0.0;
    boolean shallwrite = false;
    boolean write_moves = false;
    boolean write_vis = false;
    boolean no_knock_over = false;
    int circlevertices = 4;
    IntegerHashMap statuschanges = new IntegerHashMap();
    double factor = 1.0;
    protected LinkedList<Obstacle>[] obstacles = new LinkedList[5];
    protected LinkedList<Obstacle>[] maxCObstacles = new LinkedList[5];
    protected LinkedList<Obstacle>[] minCObstacles = new LinkedList[5];
    LinkedList<Serializable>[] Graph = new LinkedList[5];
    LinkedList<Serializable>[] MinGraph = new LinkedList[5];
    PositionHashMap[] shortestpaths = new PositionHashMap[5];
    PositionHashMap[] Minshortestpaths = new PositionHashMap[5];

    public static ModuleInfo getInfo() {
        return info;
    }

    public DisasterArea(int nodes, double x, double y, double duration, double ignore, long randomSeed, double minspeed, double maxspeed, double maxpause, double maxdist, double avgMobileNodesPerGroup, double groupSizeDeviation, double pGroupChange) {
        super(nodes, x, y, duration, ignore, randomSeed, minspeed, maxspeed, maxpause);
        this.maxdist = maxdist;
        this.avgMobileNodesPerGroup = avgMobileNodesPerGroup;
        this.groupSizeDeviation = groupSizeDeviation;
        this.pGroupChange = pGroupChange;
        for (int i = 0; i < 5; ++i) {
            this.obstacles[i] = new LinkedList();
        }
        this.generate();
    }

    public DisasterArea(String[] args) {
        for (int i = 0; i < 5; ++i) {
            this.obstacles[i] = new LinkedList();
        }
        this.go(args);
    }

    @Override
    public void go(String[] args) {
        super.go(args);
        this.generate();
    }

    public void generate() {
        int i;
        this.processArguments();
        this.preGeneration();
        if (this.numCatastropheAreas != this.maxCatastropheAreas) {
            System.out.println("You wanted to specify " + this.maxCatastropheAreas + " catastrophe areas but specified only " + this.numCatastropheAreas + ". Please specify the correct number of areas!\nFor different number of areas see -e\naborting...");
            System.exit(0);
        }
        int toArea = 0;
        for (int t = 0; t < 5; ++t) {
            this.maxCObstacles[t] = new LinkedList();
            this.minCObstacles[t] = new LinkedList();
            this.shortestpaths[t] = new PositionHashMap();
            this.Minshortestpaths[t] = new PositionHashMap();
            for (i = 0; i < this.catastropheAreas.length; ++i) {
                boolean add = false;
                switch (t) {
                    case 4: {
                        if (this.catastropheAreas[i].type == 4 || !this.no_knock_over) break;
                        add = true;
                    }
                }
                if (!add) continue;
                double[] CA_Params = this.catastropheAreas[i].getPolygonParams();
                Obstacle newone = new Obstacle(CA_Params);
                this.obstacles[t].add(newone);
            }
            System.out.println("#Obstacle[Type:" + t + "] = " + this.obstacles[t].size());
            for (i = 0; i < this.obstacles[t].size(); ++i) {
                this.maxCObstacles[t].add(this.obstacles[t].get(i).computeCObstacle(this.maxdist, this.circlevertices));
            }
            if (this.mindist != this.maxdist) {
                for (i = 0; i < this.obstacles[t].size(); ++i) {
                    this.minCObstacles[t].add(this.obstacles[t].get(i).computeCObstacle(this.mindist, this.circlevertices));
                }
            } else {
                this.minCObstacles[t] = this.maxCObstacles[t];
            }
            this.Graph[t] = this.VisibilityGraph(this.maxCObstacles[t], t);
            this.MinGraph[t] = this.VisibilityGraph(this.minCObstacles[t], t);
            for (i = 0; i < ((LinkedList)this.Graph[t].get(0)).size(); ++i) {
                this.shortestpaths[t].put((Position)((LinkedList)this.Graph[t].get(0)).get(i), this.Dijkstra(this.Graph[t], (Position)((LinkedList)this.Graph[t].get(0)).get(i)));
            }
            for (i = 0; i < ((LinkedList)this.MinGraph[t].get(0)).size(); ++i) {
                this.Minshortestpaths[t].put((Position)((LinkedList)this.MinGraph[t].get(0)).get(i), this.Dijkstra(this.MinGraph[t], (Position)((LinkedList)this.MinGraph[t].get(0)).get(i)));
            }
            System.out.println("FINISHED: compute visibility graphs type: " + t);
        }
        int nodesneeded = 0;
        for (i = 0; i < this.catastropheAreas.length; ++i) {
            for (int j = 0; j < this.obstacles[this.catastropheAreas[i].type].size(); ++j) {
                if (!this.catastropheAreas[i].intersects(this.obstacles[this.catastropheAreas[i].type].get(j).getBounds())) continue;
                System.out.println("NOTE: in " + DisasterArea.getInfo().name + ", one Obstacle's (" + j + ") Bounds intersect a Catastrophe Area - type " + this.catastropheAreas[i].type + " \n");
            }
            nodesneeded += this.catastropheAreas[i].groupsize[0] * this.catastropheAreas[i].numtransportgroups + this.catastropheAreas[i].groupsize[1] * (this.catastropheAreas[i].wantedgroups - this.catastropheAreas[i].numtransportgroups);
            int help = this.catastropheAreas[i].groupsize[0] * this.catastropheAreas[i].numtransportgroups + this.catastropheAreas[i].groupsize[1] * (this.catastropheAreas[i].wantedgroups - this.catastropheAreas[i].numtransportgroups);
            System.out.println("Area: " + i + "(Type: " + this.catastropheAreas[i].type + ") -->" + this.catastropheAreas[i].groupsize[0] + " * " + this.catastropheAreas[i].numtransportgroups + " + " + this.catastropheAreas[i].groupsize[1] + " * (" + this.catastropheAreas[i].wantedgroups + "-" + this.catastropheAreas[i].numtransportgroups + ") = " + help);
            this.determineway(this.catastropheAreas[i]);
        }
        if (nodesneeded != this.parameterData.nodes.length) {
            System.out.println("You specified wrong number of nodes to fulfill the requirements arisen by your Area specifications, nodesneeded " + nodesneeded + " nodes " + this.parameterData.nodes.length);
            System.exit(0);
        }
        System.out.println("Start creating " + this.parameterData.nodes.length + " nodes \n");
        CatastropheNode[] node = new CatastropheNode[this.parameterData.nodes.length];
        Vector<CatastropheNode> rpoints = new Vector<CatastropheNode>();
        this.oldmaxpause = this.maxpause;
        int nodesRemaining = node.length;
        int offset = 0;
        while (nodesRemaining > 0) {
            CatastropheNode ref1;
            for (int i2 = 0; i2 < this.catastropheAreas.length; ++i2) {
                if (this.catastropheAreas[i2].locatedgroups >= this.catastropheAreas[i2].wantedgroups) continue;
                toArea = i2;
                ++this.catastropheAreas[i2].locatedgroups;
                break;
            }
            CatastropheNode ref = null;
            if (this.catastropheAreas[toArea].assignedtransportgroups < this.catastropheAreas[toArea].numtransportgroups) {
                ref = ref1 = new CatastropheNode(toArea, 0, this.catastropheAreas[toArea].entry, this.catastropheAreas[toArea].exit);
                ++this.catastropheAreas[toArea].assignedtransportgroups;
            } else {
                ref = ref1 = new CatastropheNode(toArea, 1, this.catastropheAreas[toArea].entry, this.catastropheAreas[toArea].exit);
            }
            rpoints.addElement(ref);
            double t = 0.0;
            Position src = this.DetRandDst(this.catastropheAreas[ref.belongsto].getBounds().x, this.catastropheAreas[ref.belongsto].getBounds().x + this.catastropheAreas[ref.belongsto].getBounds().width, this.catastropheAreas[ref.belongsto].getBounds().y + this.catastropheAreas[ref.belongsto].getBounds().height, this.catastropheAreas[ref.belongsto].getBounds().y, this.catastropheAreas[ref.belongsto]);
            if (!ref.add(0.0, src)) {
                System.out.println(DisasterArea.getInfo().name + ".generate: error while adding group movement (1)");
                System.exit(0);
            }
            while (t < this.parameterData.duration) {
                double initial_maxpause;
                double pause;
                LinkedList<Object> movementcycle = new LinkedList();
                movementcycle = this.determineMovementCycle(this.catastropheAreas[ref.belongsto], ref);
                double speed = 0.0;
                this.maxspeed = this.catastropheAreas[ref.belongsto].maxspeed[ref.type];
                this.minspeed = this.catastropheAreas[ref.belongsto].minspeed[ref.type];
                speed = (this.maxspeed - this.minspeed) * this.randomNextDouble() + this.minspeed;
                if (t == 0.0 && !ref.add(t += (pause = (initial_maxpause = (2.0 * this.parameterData.x + 2.0 * this.parameterData.y) / this.minspeed) * this.randomNextDouble()), src)) {
                    System.out.println(DisasterArea.getInfo().name + ".generate: error while adding group movement (2)");
                    System.exit(0);
                }
                for (int i3 = 0; i3 < movementcycle.size(); ++i3) {
                    double pause2;
                    this.dst = (Position)movementcycle.get(i3);
                    if (!ref.add(t += src.distance(this.dst) / speed, this.dst)) {
                        System.out.println(DisasterArea.getInfo().name + ".generate: error while adding group movement (2)");
                        System.exit(0);
                    }
                    if (t < this.parameterData.duration && this.maxpause > 0.0 && (pause2 = this.maxpause * this.randomNextDouble()) > 0.0 && !ref.add(t += pause2, this.dst)) {
                        System.out.println(DisasterArea.getInfo().name + ".generate: error while adding node movement (3)");
                        System.exit(0);
                    }
                    src = this.dst;
                }
            }
            int size = 0;
            size = ref.type == 0 ? this.catastropheAreas[ref.belongsto].groupsize[0] : this.catastropheAreas[ref.belongsto].groupsize[1];
            if (size > nodesRemaining) {
                size = nodesRemaining;
            }
            if (size > this.maxGroupSize) {
                this.maxGroupSize = size;
            }
            nodesRemaining -= size;
            for (int i4 = (offset += size) - size; i4 < offset; ++i4) {
                node[i4] = new CatastropheNode(ref);
            }
            ++this.groups;
        }
        for (int i5 = 0; i5 < node.length; ++i5) {
            LinkedList<Double> statuschangetimes = new LinkedList<Double>();
            double t = 0.0;
            CatastropheNode group = node[i5].group();
            this.maxspeed = this.catastropheAreas[group.belongsto].maxspeed[group.type];
            this.minspeed = this.catastropheAreas[group.belongsto].minspeed[group.type];
            Position src = null;
            src = group.positionAt(t).rndprox(this.maxdist, this.randomNextDouble(), this.randomNextDouble(), this.parameterData.calculationDim);
            if (!node[i5].add(0.0, src)) {
                System.out.println(DisasterArea.getInfo().name + ".generate: error while adding node movement (1)");
                System.exit(0);
            }
            while (t < this.parameterData.duration) {
                Position dst;
                double speed;
                boolean pause;
                int gmi;
                double[] gm = group.changeTimes();
                for (gmi = 0; gmi < gm.length && gm[gmi] <= t; ++gmi) {
                }
                boolean bl = pause = gmi == 0;
                if (!pause) {
                    Position pos1 = group.positionAt(gm[gmi - 1]);
                    Position pos2 = group.positionAt(gm[gmi]);
                    pause = pos1.equals(pos2);
                }
                double next = gmi < gm.length ? gm[gmi] : this.parameterData.duration;
                do {
                    dst = group.positionAt(next).rndprox(this.maxdist, this.randomNextDouble(), this.randomNextDouble(), this.parameterData.calculationDim);
                    speed = src.distance(dst) / (next - t);
                } while (!pause && speed > this.maxspeed);
                if (speed > this.maxspeed) {
                    double c_dst = ((this.maxspeed - this.minspeed) * this.randomNextDouble() + this.minspeed) / speed;
                    double c_src = 1.0 - c_dst;
                    dst = new Position(c_src * src.x + c_dst * dst.x, c_src * src.y + c_dst * dst.y);
                }
                if (!node[i5].add(next, dst)) {
                    System.out.println(DisasterArea.getInfo().name + ".generate: error while adding node movement (4)");
                    System.exit(0);
                }
                if (this.catastropheAreas[node[i5].belongsto].type == 4 && node[i5].type == 0 && (group.positionAt(next).equals(this.catastropheAreas[node[i5].belongsto].borderentry) || group.positionAt(next).equals(this.catastropheAreas[node[i5].belongsto].borderexit))) {
                    Double value = next;
                    statuschangetimes.add(value);
                }
                src = dst;
                t = next;
            }
            if (this.catastropheAreas[node[i5].belongsto].type != 4 || node[i5].type != 0) continue;
            Integer nodeaddress = i5;
            this.statuschanges.put(nodeaddress, statuschangetimes);
        }
        this.parameterData.nodes = node;
        if (this.shallwrite) {
            this.mywrite();
        }
        this.postGeneration();
    }

    @Override
    protected boolean parseArg(String key, String value) {
        if (key.equals("groupsize_E")) {
            this.avgMobileNodesPerGroup = Double.parseDouble(value);
            System.out.println("avgMobileNodesPerGroup will not be considered in this model, because the group sizes depend on the areas");
            return true;
        }
        if (key.contains("catatastropheArea")) {
            this.catastropheAreaArgs.add(value);
            return true;
        }
        if (key.equals("pGroupChange")) {
            this.pGroupChange = Double.parseDouble(value);
            System.out.println("Group Change will not be considered in this model, because the groups belong to areas");
            return true;
        }
        if (key.equals("maxCataAreas")) {
            this.maxCatastropheAreas = (int)Double.parseDouble(value);
            return true;
        }
        if (key.equals("circleVertices")) {
            this.circlevertices = (int)Double.parseDouble(value);
            return true;
        }
        if (key.equals("maxspeed")) {
            System.out.println("In this model you can't specify maxspeed using area dependend speed");
            return true;
        }
        if (key.equals("factor")) {
            this.factor = Double.parseDouble(value);
            return true;
        }
        if (key.equals("minspeed")) {
            System.out.println("In this model you can't specify minspeed using area dependend speed");
            return true;
        }
        if (key.equals("obstacleForAllGrps")) {
            int i;
            double[] obstacleParams = DisasterArea.parseDoubleArray(value);
            for (i = 0; i < obstacleParams.length; i += 2) {
                if (!(obstacleParams[i] > this.parameterData.x)) continue;
                System.out.println("Obstacles' x-coordinates should be in scenario range");
                System.exit(0);
            }
            for (i = 1; i < obstacleParams.length; i += 2) {
                if (!(obstacleParams[i] > this.parameterData.y)) continue;
                System.out.println("Obstacles' y-coordinates should be in scenario range");
                System.exit(0);
            }
            Obstacle newone = new Obstacle(obstacleParams);
            for (int i2 = 0; i2 < 5; ++i2) {
                this.obstacles[i2].add(newone);
            }
            this.onlyOneObstacle = true;
            return true;
        }
        if (key.contains("obstacleForOnlyOneGroup")) {
            int i;
            double[] help_param = DisasterArea.parseDoubleArray(value);
            double[] obstacleParams_group = new double[help_param.length - 1];
            System.arraycopy(help_param, 0, obstacleParams_group, 0, help_param.length - 1);
            for (i = 0; i < obstacleParams_group.length; i += 2) {
                if (!(obstacleParams_group[i] > this.parameterData.x)) continue;
                System.out.println("Obstacles' x-coordinates should be in scenario range");
                System.exit(0);
            }
            for (i = 1; i < obstacleParams_group.length; i += 2) {
                if (!(obstacleParams_group[i] > this.parameterData.y)) continue;
                System.out.println("Obstacles' y-coordinates should be in scenario range");
                System.exit(0);
            }
            Obstacle newone_group = new Obstacle(obstacleParams_group);
            this.obstacles[(int)help_param[help_param.length - 1]].add(newone_group);
            this.onlyOneObstacle = false;
            if (help_param[help_param.length - 1] == 4.0) {
                this.addObsT4 = true;
            }
            return true;
        }
        if (key.equals("mindist")) {
            this.mindist = Double.parseDouble(value);
            return true;
        }
        if (key.equals("maxdist")) {
            this.oldmaxdist = this.maxdist = Double.parseDouble(value);
            return true;
        }
        if (key.equals("groupsize_S")) {
            this.groupSizeDeviation = Double.parseDouble(value);
            System.out.println("Group Size Deviation will not be considered in this model, because the group sizes depend on the areas");
            return true;
        }
        if (key.equals("writeMoves")) {
            boolean writeMoves = Boolean.parseBoolean(value);
            if (writeMoves) {
                this.shallwrite = true;
                this.write_moves = true;
            }
            return true;
        }
        if (key.equals("writeVisibilityGraph")) {
            boolean writeVisibilityGraph = Boolean.parseBoolean(value);
            if (writeVisibilityGraph) {
                this.shallwrite = true;
                this.write_vis = true;
            }
            return true;
        }
        if (key.equals("noKnockOver")) {
            boolean knock = Boolean.parseBoolean(value);
            if (knock) {
                this.no_knock_over = true;
            }
            return true;
        }
        return super.parseArg(key, value);
    }

    @Override
    public void write(String _name) throws FileNotFoundException, IOException {
        int i;
        int obsCount = 1;
        if (!this.onlyOneObstacle) {
            obsCount = 0;
            for (int i2 = 0; i2 < 5; ++i2) {
                if (this.obstacles[i2].size() == 0) continue;
                ++obsCount;
            }
            if (!this.addObsT4) {
                --obsCount;
            }
        }
        String[] p = new String[11 + this.maxCatastropheAreas + obsCount];
        int idx = 0;
        p[idx++] = "groupsize_E=" + this.avgMobileNodesPerGroup;
        for (i = 0; i < this.catastropheAreas.length; ++i) {
            CatastropheArea area = this.catastropheAreas[i];
            double[] params = area.getPolygonParams();
            Object paramsAsString = "";
            for (int j = 0; j < params.length; ++j) {
                paramsAsString = (String)paramsAsString + (int)params[j] + ",";
            }
            Object APPBorderEntryExit = "";
            if (area.type == 4) {
                APPBorderEntryExit = (int)area.borderentry.x + "," + (int)area.borderentry.y + "," + (int)area.borderexit.x + "," + (int)area.borderexit.y + ",";
            }
            p[idx++] = "catatastropheArea" + i + "=" + (String)paramsAsString + (String)APPBorderEntryExit + (int)area.entry.x + "," + (int)area.entry.y + "," + (int)area.exit.x + "," + (int)area.exit.y + "," + area.type + "," + area.wantedgroups + "," + area.numtransportgroups;
        }
        p[idx++] = "pGroupChange=" + this.pGroupChange;
        p[idx++] = "maxCataAreas=" + this.maxCatastropheAreas;
        p[idx++] = "circleVertices=" + this.circlevertices;
        p[idx++] = "factor=" + this.factor;
        if (this.obstacles != null && this.obstacles.length > 0) {
            if (this.onlyOneObstacle) {
                double[] obsVertices = this.obstacles[0].getFirst().getVertices();
                Object obsVerticesAsString = "";
                for (int i3 = 0; i3 < obsVertices.length; ++i3) {
                    obsVerticesAsString = (String)obsVerticesAsString + (int)obsVertices[i3];
                    if (i3 >= obsVertices.length - 1) continue;
                    obsVerticesAsString = (String)obsVerticesAsString + ",";
                }
                p[idx++] = "obstacleForAllGrps=" + (String)obsVerticesAsString;
            } else {
                for (i = 0; i < this.obstacles.length; ++i) {
                    if (this.obstacles[i].size() == 0 || i == 4 && !this.addObsT4) continue;
                    double[] obsVertices = this.obstacles[i].getFirst().getVertices();
                    Object obsVerticesAsString = "";
                    for (int j = 0; j < obsVertices.length; ++j) {
                        obsVerticesAsString = (String)obsVerticesAsString + (int)obsVertices[j];
                        if (j >= obsVertices.length - 1) continue;
                        obsVerticesAsString = (String)obsVerticesAsString + ",";
                    }
                    p[idx++] = "obstacleForOnlyOneGroup" + i + "=" + (String)obsVerticesAsString + "," + i;
                }
            }
        }
        p[idx++] = "mindist=" + this.mindist;
        p[idx++] = "maxdist=" + this.maxdist;
        p[idx++] = "groupsize_S=" + this.groupSizeDeviation;
        p[idx++] = "writeMoves=" + (this.shallwrite && this.write_moves);
        p[idx++] = "writeVisibilityGraph=" + (this.shallwrite && this.write_vis);
        p[idx] = "noKnockOver=" + this.no_knock_over;
        PrintWriter changewriter = new PrintWriter(new BufferedWriter(new FileWriter(_name + ".changes")));
        for (Map.Entry entry : this.statuschanges.entrySet()) {
            Integer key = (Integer)entry.getKey();
            changewriter.write(key.toString());
            changewriter.write(" ");
        }
        changewriter.close();
        super.write(_name, p);
    }

    private void processArguments() {
        if (this.catastropheAreaArgs.size() > this.maxCatastropheAreas) {
            System.out.println("Only " + this.maxCatastropheAreas + " CatastropheAreas permitted in this model");
            System.exit(0);
        }
        this.catastropheAreas = new CatastropheArea[this.maxCatastropheAreas];
        for (String arg : this.catastropheAreaArgs) {
            int i;
            int check_till;
            ++this.numCatastropheAreas;
            double[] areaParams = DisasterArea.parseDoubleArray(arg);
            if (areaParams[check_till = areaParams.length - 3] == 4.0) {
                check_till = areaParams.length - 12;
            }
            for (i = 0; i < check_till; i += 2) {
                if (!(areaParams[i] > this.parameterData.x - this.maxdist) && !(areaParams[i] < 0.0 + this.maxdist)) continue;
                System.out.println("Areas' x-coordinates should be in scenario range and not too near to border");
                System.out.println("Area-Type: " + areaParams[areaParams.length - 3] + "maxdist " + this.maxdist + " Params " + areaParams[i]);
                System.exit(0);
            }
            for (i = 1; i < check_till; i += 2) {
                if (!(areaParams[i] > this.parameterData.y - this.maxdist) && !(areaParams[i] < 0.0 + this.maxdist)) continue;
                System.out.println("Areas' y-coordinates should be in scenario range and not too near to border");
                System.out.println("Area-Type: " + areaParams[areaParams.length - 3] + " maxdist " + this.maxdist + " Params " + areaParams[i]);
                System.exit(0);
            }
            this.catastropheAreas[this.numCatastropheAreas - 1] = CatastropheArea.GetInstance(areaParams);
        }
        this.catastropheAreaArgs = null;
    }

    @Override
    protected boolean parseArg(char key, String val) {
        switch (key) {
            case 'a': {
                this.avgMobileNodesPerGroup = Double.parseDouble(val);
                System.out.println("avgMobileNodesPerGroup will not be considered in this model, because the group sizes depend on the areas");
                return true;
            }
            case 'b': {
                this.catastropheAreaArgs.add(val);
                return true;
            }
            case 'c': {
                this.pGroupChange = 0.0;
                System.out.println("Group Change will not be considered in this model, because the groups belong to areas");
                return true;
            }
            case 'e': {
                this.maxCatastropheAreas = (int)Double.parseDouble(val);
                return true;
            }
            case 'g': {
                this.circlevertices = (int)Double.parseDouble(val);
            }
            case 'h': {
                System.out.println("In this model you can't specify maxspeed using area dependend speed");
                return true;
            }
            case 'j': {
                this.factor = Double.parseDouble(val);
                return true;
            }
            case 'l': {
                System.out.println("In this model you can't specify minspeed using area dependend speed");
                return true;
            }
            case 'o': {
                int i;
                double[] obstacleParams = DisasterArea.parseDoubleArray(val);
                for (i = 0; i < obstacleParams.length; i += 2) {
                    if (!(obstacleParams[i] > this.parameterData.x)) continue;
                    System.out.println("Obstacles' x-coordinates should be in scenario range");
                    System.exit(0);
                }
                for (i = 1; i < obstacleParams.length; i += 2) {
                    if (!(obstacleParams[i] > this.parameterData.y)) continue;
                    System.out.println("Obstacles' y-coordinates should be in scenario range");
                    System.exit(0);
                }
                Obstacle newone = new Obstacle(obstacleParams);
                for (int i2 = 0; i2 < 5; ++i2) {
                    this.obstacles[i2].add(newone);
                }
                this.onlyOneObstacle = true;
                return true;
            }
            case 'O': {
                int i;
                double[] help_param = DisasterArea.parseDoubleArray(val);
                double[] obstacleParams_group = new double[help_param.length - 1];
                System.arraycopy(help_param, 0, obstacleParams_group, 0, help_param.length - 1);
                for (i = 0; i < obstacleParams_group.length; i += 2) {
                    if (!(obstacleParams_group[i] > this.parameterData.x)) continue;
                    System.out.println("Obstacles' x-coordinates should be in scenario range");
                    System.exit(0);
                }
                for (i = 1; i < obstacleParams_group.length; i += 2) {
                    if (!(obstacleParams_group[i] > this.parameterData.y)) continue;
                    System.out.println("Obstacles' y-coordinates should be in scenario range");
                    System.exit(0);
                }
                Obstacle newone_group = new Obstacle(obstacleParams_group);
                this.obstacles[(int)help_param[help_param.length - 1]].add(newone_group);
                this.onlyOneObstacle = false;
                if (help_param[help_param.length - 1] == 4.0) {
                    this.addObsT4 = true;
                }
                return true;
            }
            case 'q': {
                this.mindist = Double.parseDouble(val);
                return true;
            }
            case 'r': {
                this.oldmaxdist = this.maxdist = Double.parseDouble(val);
                return true;
            }
            case 's': {
                this.groupSizeDeviation = Double.parseDouble(val);
                System.out.println("Group Size Deviation will not be considered in this model, because the group sizes depend on the areas");
                return true;
            }
            case 'w': {
                this.shallwrite = true;
                this.write_moves = true;
                return true;
            }
            case 'v': {
                this.shallwrite = true;
                this.write_vis = true;
                return true;
            }
            case 'K': {
                this.no_knock_over = true;
                return true;
            }
        }
        return super.parseArg(key, val);
    }

    public static void printHelp() {
        System.out.println(DisasterArea.getInfo().toDetailString());
        RandomSpeedBase.printHelp();
        System.out.println(DisasterArea.getInfo().name + ":");
        System.out.println("\t-a <average no. of nodes per group>");
        System.out.println("\t-b <catastrophe area (can be used multiple times for several catastrophe areas)>");
        System.out.println("\t-c <group change probability>");
        System.out.println("\t-e <max catastrophe areas>");
        System.out.println("\t-r <max. distance to group center>");
        System.out.println("\t-s <group size standard deviation>");
        System.out.println("\t-O <obstacle for only one group (specified in last param)>");
        System.out.println("\t-w <write vis. info to file & show movements>");
        System.out.println("\t-v <write vis. info to file & show vis.graph>");
        System.out.println("\t-K <do not knock over pedestrians - no ambulances in areas beside APP>");
    }

    public Position DetRandDst(double xleft, double xright, double ylow, double yhigh, CatastropheArea area) {
        int maximum = 0;
        boolean inobstacle = false;
        Position newdst = null;
        while (maximum < 10000) {
            newdst = new Position(xleft + this.randomNextDouble() * (xright - xleft), yhigh + this.randomNextDouble() * (ylow - yhigh));
            if (debug) {
                System.out.println("yhigh " + yhigh + " ylow " + ylow + " xright " + xright + " xleft " + xleft);
                System.out.println("dst " + newdst.x + " " + newdst.y);
                double test1 = newdst.x - this.maxdist;
                double test2 = newdst.y - this.maxdist;
                double test3 = 2.0 * this.maxdist;
                double test4 = 2.0 * this.maxdist;
                System.out.println("area contains " + area.contains(test1, test2, test3, test4));
                System.out.println("area contains point(x,y) " + area.contains(test1, test2));
                System.out.println("area contains point(x,y+height) " + area.contains(test1, test2 + test3));
                System.out.println("area contains point(x+width,y) " + area.contains(test1 + test3, test2));
                System.out.println("area contains point(x+width,y+height) " + area.contains(test1 + test3, test2 + test4));
                System.out.println("berechnete Werte " + test1 + " " + test2 + " " + test3 + " " + test4);
                Rectangle test = new Rectangle((int)newdst.x - (int)this.maxdist, (int)newdst.y - (int)this.maxdist, 2 * (int)this.maxdist, 2 * (int)this.maxdist);
                System.out.println("Rechteck x" + test.x + " y " + test.y + " width " + test.width + " height " + test.height);
            }
            if (area.contains(newdst.x - this.maxdist, newdst.y - this.maxdist, 2.0 * this.maxdist, 2.0 * this.maxdist)) {
                for (int i = 0; i < this.obstacles[area.type].size(); ++i) {
                    inobstacle = this.obstacles[area.type].get(i).contains(newdst.x, newdst.y);
                    if (!inobstacle) continue;
                    ++maximum;
                    break;
                }
                if (inobstacle) continue;
                if (this.OnObstacleBorder(newdst, area)) {
                    System.out.println("Fehler bei detranddst");
                }
                return newdst;
            }
            ++maximum;
        }
        System.out.println("Please enlarge your area or specify other obstacles, System was not able to compute valid destination - DetRandDst(" + area.type + ")");
        System.out.println("exit(0) but HACKED");
        System.exit(0);
        return null;
    }

    public boolean OnObstacleBorder(Position dst, CatastropheArea area) {
        for (int i = 0; i < this.obstacles[area.type].size(); ++i) {
            if (!this.obstacles[area.type].get(i).intersectsLine(dst.x, dst.y, dst.x, dst.y)) continue;
            this.obstacles[area.type].get(i).print();
            return true;
        }
        return false;
    }

    public void mywrite() {
        int t = 4;
        try {
            int i;
            PrintWriter mywriter = new PrintWriter(new BufferedWriter(new FileWriter("Aspects.txt")));
            System.out.println("habe erstellt Aspects.txt");
            for (i = 0; i < this.catastropheAreas.length; ++i) {
                mywriter.write("Area");
                mywriter.write(this.catastropheAreas[i].VerticesToString());
                mywriter.write("\n");
            }
            for (i = 0; i < this.obstacles[t].size(); ++i) {
                mywriter.write("Obstacle");
                mywriter.write(this.obstacles[t].get(i).VerticesToString());
                mywriter.write("\n");
            }
            for (i = 0; i < this.maxCObstacles[t].size(); ++i) {
                mywriter.write("maxCObstacle");
                mywriter.write(this.maxCObstacles[t].get(i).VerticesToString());
                mywriter.write("\n");
            }
            for (i = 0; i < this.minCObstacles[t].size(); ++i) {
                mywriter.write("minCObstacle");
                mywriter.write(this.minCObstacles[t].get(i).VerticesToString());
                mywriter.write("\n");
            }
            if (this.write_vis) {
                for (i = 0; i < ((LinkedList)this.Graph[t].get(0)).size(); ++i) {
                    Position key = (Position)((LinkedList)this.Graph[t].get(0)).get(i);
                    for (int j = 0; j < ((LinkedList)((PositionHashMap)this.Graph[t].get(1)).get(key)).size(); ++j) {
                        mywriter.write("Visline ");
                        mywriter.write(((Line2D.Double)((LinkedList)((PositionHashMap)this.Graph[t].get((int)1)).get((Position)key)).get((int)j)).x1 + " " + ((Line2D.Double)((LinkedList)((PositionHashMap)this.Graph[t].get((int)1)).get((Position)key)).get((int)j)).y1 + " " + ((Line2D.Double)((LinkedList)((PositionHashMap)this.Graph[t].get((int)1)).get((Position)key)).get((int)j)).x2 + " " + ((Line2D.Double)((LinkedList)((PositionHashMap)this.Graph[t].get((int)1)).get((Position)key)).get((int)j)).y2);
                        mywriter.write("\n");
                    }
                }
                System.out.println("wrote VisibilityGraph infos");
            }
            if (this.write_moves) {
                for (i = 0; i < this.parameterData.nodes.length; ++i) {
                    String movement = this.parameterData.nodes[i].movementString(this.parameterData.outputDim);
                    mywriter.write("Bewegung ");
                    mywriter.write(movement);
                    mywriter.write("\n");
                }
            }
            mywriter.close();
        }
        catch (Exception e) {
            System.out.println("Something is wrong with the File specified at Extended Catastrophe mywrite()");
            System.exit(0);
        }
    }

    public LinkedList<Position> determineway(CatastropheArea area) {
        LinkedList<CatastropheArea> possibleAreas = this.determineAreastovisit(area);
        LinkedList completeway = null;
        LinkedList tempway = null;
        LinkedList tempway2 = null;
        Position src = null;
        Position toreach = null;
        double mindist2 = Double.MAX_VALUE;
        double tempdist = 0.0;
        for (int i = 0; i < possibleAreas.size(); ++i) {
            int j;
            switch (area.type) {
                case 0: {
                    Position src1;
                    Position end1;
                    toreach = end1 = new Position(possibleAreas.get((int)i).entry.x, possibleAreas.get((int)i).entry.y);
                    src = src1 = new Position(area.exit.x, area.exit.y);
                    break;
                }
                case 1: {
                    Position src2;
                    Position end2;
                    toreach = end2 = new Position(possibleAreas.get((int)i).entry.x, possibleAreas.get((int)i).entry.y);
                    src = src2 = new Position(area.exit.x, area.exit.y);
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    Position src3;
                    Position end3;
                    toreach = end3 = new Position(possibleAreas.get((int)i).exit.x, possibleAreas.get((int)i).exit.y);
                    src = src3 = new Position(area.exit.x, area.exit.y);
                    break;
                }
                default: {
                    System.out.println("Error in " + DisasterArea.getInfo().name + ", couldn't determine way");
                    System.exit(0);
                }
            }
            if (src == null || toreach == null) continue;
            PositionHashMap waysForSrc = (PositionHashMap)this.shortestpaths[area.type].get(src);
            PositionHashMap MinwaysForSrc = (PositionHashMap)this.Minshortestpaths[area.type].get(src);
            tempway = (LinkedList)waysForSrc.get(toreach);
            tempway2 = (LinkedList)MinwaysForSrc.get(toreach);
            for (j = 0; j < tempway.size() - 1; ++j) {
                tempdist += ((Position)tempway.get(j)).distance((Position)tempway.get(j + 1));
            }
            if (tempdist < mindist2) {
                this.maxdist = this.oldmaxdist;
                mindist2 = tempdist;
                completeway = tempway;
            }
            tempdist = 0.0;
            for (j = 0; j < tempway2.size() - 1; ++j) {
                tempdist += ((Position)tempway2.get(j)).distance((Position)tempway2.get(j + 1));
            }
            if ((tempdist *= this.factor) < mindist2) {
                this.maxdist = this.mindist;
                mindist2 = tempdist;
                completeway = tempway2;
            }
            tempdist = 0.0;
            mindist2 = Double.MAX_VALUE;
            area.allways.add(completeway);
        }
        return completeway;
    }

    public LinkedList<CatastropheArea> determineAreastovisit(CatastropheArea area) {
        LinkedList<CatastropheArea> Areastovisit = new LinkedList<CatastropheArea>();
        LinkedList<Integer> arraypos = new LinkedList<Integer>();
        switch (area.type) {
            case 0: {
                for (int i = 0; i < this.catastropheAreas.length; ++i) {
                    if (this.catastropheAreas[i].type != 1) continue;
                    Areastovisit.add(this.catastropheAreas[i]);
                    Integer temp = i;
                    arraypos.add(temp);
                }
                if (Areastovisit.size() != 0) break;
                System.out.println("Please specify a patients waiting for treatment area for incident location! aborting...");
                System.exit(0);
                break;
            }
            case 1: {
                for (int i = 0; i < this.catastropheAreas.length; ++i) {
                    if (this.catastropheAreas[i].type != 2) continue;
                    Areastovisit.add(this.catastropheAreas[i]);
                    Integer temp = i;
                    arraypos.add(temp);
                }
                if (Areastovisit.size() != 0) break;
                System.out.println("Please specify a casualties clearing station for patients waiting for treatment area! aborting...");
                System.exit(0);
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                for (int i = 0; i < this.catastropheAreas.length; ++i) {
                    if (this.catastropheAreas[i].type != 2) continue;
                    Areastovisit.add(this.catastropheAreas[i]);
                    Integer temp = i;
                    arraypos.add(temp);
                }
                if (Areastovisit.size() != 0) break;
                System.out.println("Please specify a casualties clearing station for ambulance parking point! aborting...");
                System.exit(0);
                break;
            }
            default: {
                System.out.println("Error in " + DisasterArea.getInfo().name + ", couldn't determine Areas to visit");
                System.exit(0);
            }
        }
        return Areastovisit;
    }

    public LinkedList<Position> determineMovementCycle(CatastropheArea area, CatastropheNode node) {
        int movePhase = 0;
        LinkedList<Position> cycle = new LinkedList<Position>();
        double xleft = area.getBounds().x;
        double xright = area.getBounds().x + area.getBounds().width;
        double yhigh = area.getBounds().y;
        double ylow = area.getBounds().y + area.getBounds().height;
        double whichArea = this.randomNextDouble();
        double numAreas = area.allways.size();
        double step = 1.0 / numAreas;
        int PosInList = 0;
        int i = 1;
        while ((double)i <= numAreas) {
            if (whichArea <= (double)i * step) {
                PosInList = i - 1;
                break;
            }
            ++i;
        }
        switch (area.type) {
            case 0: {
                do {
                    if (movePhase == 0) {
                        this.maxpause = this.oldmaxpause;
                        this.dst = this.DetRandDst(xleft, xright, ylow, yhigh, area);
                        cycle.add(this.dst);
                        ++movePhase;
                        continue;
                    }
                    if (movePhase == 1) {
                        this.maxpause = this.oldmaxpause;
                        for (i = 0; i < area.allways.get(PosInList).size(); ++i) {
                            this.dst = area.allways.get(PosInList).get(i);
                            cycle.add(this.dst);
                        }
                        if (area.neighborAreaPos != null && area.exit.equals(this.catastropheAreas[area.neighborAreaPos.intValue()].entry)) {
                            movePhase = 0;
                            continue;
                        }
                        ++movePhase;
                        continue;
                    }
                    if (movePhase != 2) continue;
                    this.maxpause = 0.0;
                    for (i = area.allways.get(PosInList).size() - 2; i >= 0; --i) {
                        this.dst = area.allways.get(PosInList).get(i);
                        cycle.add(this.dst);
                    }
                    movePhase = 0;
                } while (movePhase != 0);
                break;
            }
            case 1: {
                do {
                    if (node.type == 0) {
                        if (movePhase == 0) {
                            this.maxpause = this.oldmaxpause;
                            this.dst = this.DetRandDst(xleft, xright, ylow, yhigh, area);
                            cycle.add(this.dst);
                            ++movePhase;
                            continue;
                        }
                        if (movePhase == 1) {
                            this.maxpause = this.oldmaxpause;
                            for (i = 0; i < area.allways.get(PosInList).size(); ++i) {
                                this.dst = area.allways.get(PosInList).get(i);
                                cycle.add(this.dst);
                            }
                            ++movePhase;
                            continue;
                        }
                        if (movePhase != 2) continue;
                        this.maxpause = 0.0;
                        for (i = area.allways.get(PosInList).size() - 2; i >= 0; --i) {
                            this.dst = area.allways.get(PosInList).get(i);
                            cycle.add(this.dst);
                        }
                        movePhase = 0;
                        continue;
                    }
                    this.maxpause = this.oldmaxpause;
                    this.dst = this.DetRandDst(xleft, xright, ylow, yhigh, area);
                    cycle.add(this.dst);
                } while (movePhase != 0);
                break;
            }
            case 2: {
                this.maxpause = this.oldmaxpause;
                this.dst = this.DetRandDst(xleft, xright, ylow, yhigh, area);
                cycle.add(this.dst);
                break;
            }
            case 3: {
                this.maxpause = this.oldmaxpause;
                this.dst = this.DetRandDst(xleft, xright, ylow, yhigh, area);
                cycle.add(this.dst);
                break;
            }
            case 4: {
                do {
                    if (node.type == 0) {
                        int i2;
                        if (movePhase == 0) {
                            this.maxpause = this.oldmaxpause;
                            this.dst = this.DetRandDst(xleft, xright, ylow, yhigh, area);
                            cycle.add(this.dst);
                            ++movePhase;
                            continue;
                        }
                        if (movePhase == 1) {
                            this.maxpause = this.oldmaxpause;
                            for (i = 0; i < area.allways.get(PosInList).size(); ++i) {
                                this.dst = area.allways.get(PosInList).get(i);
                                cycle.add(this.dst);
                            }
                            ++movePhase;
                            continue;
                        }
                        if (movePhase != 2) continue;
                        this.maxpause = 0.0;
                        LinkedList<Position> tempway = this.waysToBorder(area.allways.get(PosInList).get(area.allways.get(PosInList).size() - 1), area);
                        for (i2 = 1; i2 < tempway.size(); ++i2) {
                            this.dst = tempway.get(i2);
                            if (i2 == tempway.size() - 1) {
                                this.dst = new Position(this.dst.x, this.dst.y, 0.0, 2.0);
                            }
                            cycle.add(this.dst);
                        }
                        tempway = this.determineBorderWay(area.borderentry, area.borderexit);
                        for (i2 = 0; i2 < tempway.size(); ++i2) {
                            this.dst = tempway.get(i2);
                            cycle.add(this.dst);
                        }
                        tempway = this.waysFromBorder(area.allways.get(PosInList).get(area.allways.get(PosInList).size() - 1), area);
                        for (i2 = 1; i2 < tempway.size(); ++i2) {
                            this.dst = tempway.get(i2);
                            if (i2 == tempway.size() - 1) {
                                this.dst = new Position(this.dst.x, this.dst.y, 0.0, 1.0);
                            }
                            cycle.add(this.dst);
                        }
                        movePhase = 0;
                        continue;
                    }
                    this.maxpause = this.oldmaxpause;
                    this.dst = this.DetRandDst(xleft, xright, ylow, yhigh, area);
                    cycle.add(this.dst);
                } while (movePhase != 0);
                break;
            }
            default: {
                System.out.println("Error in " + DisasterArea.getInfo().name + ", couldn't determine Movement Cycle");
                System.exit(0);
            }
        }
        return cycle;
    }

    public LinkedList<Serializable> VisibilityGraph(LinkedList<Obstacle> CObstacles, int type) {
        int i;
        LinkedList<Position> Vertices = new LinkedList<Position>();
        PositionHashMap Edges = new PositionHashMap();
        LinkedList<Serializable> VisGraph = new LinkedList<Serializable>();
        for (i = 0; i < CObstacles.size(); ++i) {
            Position[] temp = CObstacles.get(i).getPosVertices();
            for (int j = 0; j < temp.length; ++j) {
                Vertices.add(temp[j]);
            }
        }
        block9: for (i = 0; i < this.catastropheAreas.length; ++i) {
            switch (type) {
                case 4: {
                    switch (this.catastropheAreas[i].type) {
                        case 4: {
                            Vertices.add(this.catastropheAreas[i].entry);
                            Vertices.add(this.catastropheAreas[i].exit);
                            Vertices.add(this.catastropheAreas[i].borderentry);
                            Vertices.add(this.catastropheAreas[i].borderexit);
                            break;
                        }
                        case 2: {
                            Vertices.add(this.catastropheAreas[i].exit);
                        }
                    }
                    continue block9;
                }
                default: {
                    Vertices.add(this.catastropheAreas[i].entry);
                    Vertices.add(this.catastropheAreas[i].exit);
                    if (this.catastropheAreas[i].type != 4) continue block9;
                    Vertices.add(this.catastropheAreas[i].borderentry);
                    Vertices.add(this.catastropheAreas[i].borderexit);
                }
            }
        }
        for (i = 0; i < Vertices.size(); ++i) {
            LinkedList<Line2D.Double> VisEdges = new LinkedList<Line2D.Double>();
            LinkedList<Object> VisVert = new LinkedList();
            VisVert = this.VisibleVertices((Position)Vertices.get(i), Vertices, CObstacles);
            for (int j = 0; j < VisVert.size(); ++j) {
                Line2D.Double line = new Line2D.Double(Vertices.get((int)i).x, Vertices.get((int)i).y, ((Position)VisVert.get((int)j)).x, ((Position)VisVert.get((int)j)).y);
                if (this.Vertice_on_Boundary(Vertices.get((int)i).x, Vertices.get((int)i).y, ((Position)VisVert.get((int)j)).x, ((Position)VisVert.get((int)j)).y)) continue;
                VisEdges.add(line);
            }
            Edges.put(Vertices.get(i), VisEdges);
        }
        VisGraph.add(Vertices);
        VisGraph.add(Edges);
        return VisGraph;
    }

    public boolean Vertice_on_Boundary(double x1, double y1, double x2, double y2) {
        if (y1 - this.maxdist <= 0.0 && y2 - this.maxdist <= 0.0) {
            return true;
        }
        if (y1 + this.maxdist >= this.parameterData.y && y2 + this.maxdist >= this.parameterData.y) {
            return true;
        }
        if (x1 - this.maxdist <= 0.0 && x2 - this.maxdist <= 0.0) {
            return true;
        }
        return x1 + this.maxdist >= this.parameterData.x && x2 + this.maxdist >= this.parameterData.x;
    }

    public LinkedList<Position> VisibleVertices(Position Vertex, LinkedList<Position> Vertices, LinkedList<Obstacle> CObstacles) {
        boolean visible = false;
        boolean sameObstacle = false;
        boolean StartOnObstacle = false;
        boolean StopOnObstacle = false;
        Obstacle obstacle = null;
        int numintersections = 0;
        LinkedList<Position> VisVert = new LinkedList<Position>();
        for (int i = 0; i < Vertices.size(); ++i) {
            numintersections = 0;
            sameObstacle = false;
            StartOnObstacle = false;
            StopOnObstacle = false;
            for (int j = 0; j < CObstacles.size(); ++j) {
                if (CObstacles.get(j).contains(Vertex.x, Vertex.y)) {
                    // empty if block
                }
                if (CObstacles.get(j).contains(Vertices.get((int)i).x, Vertices.get((int)i).y)) {
                    StopOnObstacle = true;
                }
                if (CObstacles.get(j).isVertice(Vertex)) {
                    StartOnObstacle = true;
                }
                if (CObstacles.get(j).isVertice(Vertices.get(i))) {
                    StopOnObstacle = true;
                }
                if (CObstacles.get(j).sameObstacle(Vertex, Vertices.get(i))) {
                    sameObstacle = true;
                    obstacle = CObstacles.get(j);
                }
                if (!CObstacles.get(j).intersectsLine(Vertex.x, Vertex.y, Vertices.get((int)i).x, Vertices.get((int)i).y)) continue;
                numintersections += CObstacles.get(j).intersectsObstacle(Vertex.x, Vertex.y, Vertices.get((int)i).x, Vertices.get((int)i).y);
            }
            if (numintersections == 2 && (StartOnObstacle || StopOnObstacle) && !Vertex.equals(Vertices.get(i))) {
                VisVert.add(Vertices.get(i));
            }
            if (!(numintersections != 0 || StartOnObstacle || StopOnObstacle || Vertex.equals(Vertices.get(i)))) {
                VisVert.add(Vertices.get(i));
            }
            if (sameObstacle) {
                if (numintersections == 3) {
                    VisVert.add(Vertices.get(i));
                } else if (numintersections == 4 && !obstacle.throughObstacle(Vertex.x, Vertex.y, Vertices.get((int)i).x, Vertices.get((int)i).y)) {
                    VisVert.add(Vertices.get(i));
                }
            }
            if (!(visible = numintersections == 4 && !sameObstacle && StartOnObstacle && StopOnObstacle)) continue;
            VisVert.add(Vertices.get(i));
        }
        return VisVert;
    }

    public PositionHashMap Dijkstra(LinkedList Graph, Position start) {
        PositionHashMap weights = new PositionHashMap();
        Double min = Double.MAX_VALUE;
        Position minpos = null;
        PositionHashMap ways = new PositionHashMap();
        for (int i = 0; i < ((LinkedList)Graph.get(0)).size(); ++i) {
            Double value;
            if (((Position)((LinkedList)Graph.get(0)).get(i)).equals(start)) {
                value = 0.0;
                weights.put(start, value);
                LinkedList<Position> computeway = new LinkedList<Position>();
                computeway.add(start);
                ways.put(start, computeway);
                continue;
            }
            value = Double.MAX_VALUE;
            weights.put((Position)((LinkedList)Graph.get(0)).get(i), value);
        }
        PositionHashMap vertices = new PositionHashMap();
        vertices = (PositionHashMap)weights.clone();
        while (vertices.size() != 0) {
            minpos = null;
            min = Double.MAX_VALUE;
            for (Map.Entry entry : vertices.entrySet()) {
                if (!((Double)entry.getValue() < min)) continue;
                min = (Double)entry.getValue();
                minpos = (Position)entry.getKey();
            }
            if (minpos == null) {
                return ways;
            }
            vertices.remove(minpos);
            for (int i = 0; i < ((LinkedList)((PositionHashMap)Graph.get(1)).get(minpos)).size(); ++i) {
                int j;
                LinkedList<Position> computeway;
                Double value;
                double help2;
                double help1;
                Position endpoint1 = new Position(((Line2D.Double)((LinkedList)((PositionHashMap)Graph.get((int)1)).get((Position)minpos)).get((int)i)).x1, ((Line2D.Double)((LinkedList)((PositionHashMap)Graph.get((int)1)).get((Position)minpos)).get((int)i)).y1);
                Position endpoint2 = new Position(((Line2D.Double)((LinkedList)((PositionHashMap)Graph.get((int)1)).get((Position)minpos)).get((int)i)).x2, ((Line2D.Double)((LinkedList)((PositionHashMap)Graph.get((int)1)).get((Position)minpos)).get((int)i)).y2);
                if (!endpoint1.equals(minpos) && (help1 = ((Double)weights.get(endpoint1)).doubleValue()) > (help2 = ((Double)weights.get(minpos)).doubleValue()) + minpos.distance(endpoint1)) {
                    value = help2 + minpos.distance(endpoint1);
                    weights.changeto(endpoint1, value);
                    vertices.changeto(endpoint1, value);
                    computeway = new LinkedList<Position>();
                    for (j = 0; j < ((LinkedList)ways.get(minpos)).size(); ++j) {
                        computeway.add((Position)((LinkedList)ways.get(minpos)).get(j));
                    }
                    computeway.add(endpoint1);
                    ways.changeto(endpoint1, computeway);
                }
                if (endpoint2.equals(minpos) || !((help1 = ((Double)weights.get(endpoint2)).doubleValue()) > (help2 = ((Double)weights.get(minpos)).doubleValue()) + minpos.distance(endpoint2))) continue;
                value = help2 + minpos.distance(endpoint2);
                weights.changeto(endpoint2, value);
                vertices.changeto(endpoint2, value);
                computeway = new LinkedList();
                for (j = 0; j < ((LinkedList)ways.get(minpos)).size(); ++j) {
                    computeway.add((Position)((LinkedList)ways.get(minpos)).get(j));
                }
                computeway.add(endpoint2);
                ways.changeto(endpoint2, computeway);
            }
        }
        return ways;
    }

    public LinkedList<Position> determineBorderWay(Position borderentry, Position borderexit) {
        LinkedList<Position> way = new LinkedList<Position>();
        if (borderentry.equals(borderexit)) {
            return null;
        }
        if (borderentry.x == borderexit.x) {
            way.add(borderexit);
            return way;
        }
        if (borderentry.y == borderexit.y) {
            way.add(borderexit);
            return way;
        }
        Position temp = new Position(borderentry.x, borderexit.y);
        way.add(temp);
        way.add(borderexit);
        return way;
    }

    public LinkedList<Position> waysToBorder(Position src, CatastropheArea area) {
        int i;
        double MinTempdist = 0.0;
        double MaxTempdist = 0.0;
        PositionHashMap waysForMinCObstacles = (PositionHashMap)this.Minshortestpaths[area.type].get(src);
        PositionHashMap waysForMaxCObstacles = (PositionHashMap)this.shortestpaths[area.type].get(src);
        LinkedList MinTempway = (LinkedList)waysForMinCObstacles.get(area.borderentry);
        LinkedList MaxTempway = (LinkedList)waysForMaxCObstacles.get(area.borderentry);
        for (i = 0; i < MinTempway.size() - 1; ++i) {
            MinTempdist += ((Position)MinTempway.get(i)).distance((Position)MinTempway.get(i + 1));
        }
        for (i = 0; i < MaxTempway.size() - 1; ++i) {
            MaxTempdist += ((Position)MaxTempway.get(i)).distance((Position)MaxTempway.get(i + 1));
        }
        if (MinTempdist * this.factor < MaxTempdist) {
            this.maxdist = this.mindist;
            return MinTempway;
        }
        this.maxdist = this.oldmaxdist;
        return MaxTempway;
    }

    public LinkedList<Position> waysFromBorder(Position src, CatastropheArea area) {
        int i;
        double MinTempdist = 0.0;
        double MaxTempdist = 0.0;
        PositionHashMap waysForMinCObstacles = (PositionHashMap)this.Minshortestpaths[area.type].get(src);
        PositionHashMap waysForMaxCObstacles = (PositionHashMap)this.shortestpaths[area.type].get(src);
        LinkedList MinTempway = (LinkedList)waysForMinCObstacles.get(area.entry);
        LinkedList MaxTempway = (LinkedList)waysForMaxCObstacles.get(area.entry);
        for (i = 0; i < MinTempway.size() - 1; ++i) {
            MinTempdist += ((Position)MinTempway.get(i)).distance((Position)MinTempway.get(i + 1));
        }
        for (i = 0; i < MaxTempway.size() - 1; ++i) {
            MaxTempdist += ((Position)MaxTempway.get(i)).distance((Position)MaxTempway.get(i + 1));
        }
        if (MinTempdist * this.factor < MaxTempdist) {
            this.maxdist = this.mindist;
            return MinTempway;
        }
        this.maxdist = this.oldmaxdist;
        return MaxTempway;
    }

    static {
        DisasterArea.info.description = "Application to create extended catastrophe scenarios according to the Disaster Area model";
        DisasterArea.info.major = 1;
        DisasterArea.info.minor = 0;
        DisasterArea.info.revision = ModuleInfo.getSVNRevisionStringValue("$LastChangedRevision: 650 $");
        DisasterArea.info.contacts.add("bonnmotion@lists.iai.uni-bonn.de");
        DisasterArea.info.authors.add("University of Bonn");
        DisasterArea.info.affiliation = "University of Bonn - Institute of Computer Science 4 (http://net.cs.uni-bonn.de/)";
        debug = false;
    }
}

