/*
 * Decompiled with CFR 0.152.
 */
package bonnmotion;

import bonnmotion.AmbulanceParkingPoint;
import bonnmotion.CasualtiesClearingStation;
import bonnmotion.IncidentLocation;
import bonnmotion.PatientsWaitingForThreatmentArea;
import bonnmotion.Position;
import bonnmotion.TechnicalOperationalCommand;
import java.awt.Polygon;
import java.util.LinkedList;

public abstract class CatastropheArea
extends Polygon {
    private static final long serialVersionUID = 1524633469689511126L;
    protected static boolean debug = false;
    double[] Positions = null;
    public Position entry;
    public Position exit;
    public Position borderentry;
    public Position borderexit;
    public Position[] corners = null;
    public int type;
    public int wantedgroups;
    public int locatedgroups;
    public int[] groupsize = new int[2];
    public double[] minspeed = new double[2];
    public double[] maxspeed = new double[2];
    public int numtransportgroups;
    public int assignedtransportgroups;
    public Integer neighborAreaPos = null;
    public LinkedList<LinkedList<Position>> allways = new LinkedList();

    public static CatastropheArea GetInstance(double[] Positions) {
        int type = (int)Positions[Positions.length - 3];
        switch (type) {
            case 0: {
                return new IncidentLocation(Positions);
            }
            case 1: {
                return new PatientsWaitingForThreatmentArea(Positions);
            }
            case 2: {
                return new CasualtiesClearingStation(Positions);
            }
            case 3: {
                return new TechnicalOperationalCommand(Positions);
            }
            case 4: {
                return new AmbulanceParkingPoint(Positions);
            }
        }
        throw new IllegalArgumentException("Unknown Type");
    }

    protected void InitializeSpecificValues(double[] Positions) {
        if (Positions.length < 7) {
            System.out.println("Please specify more positions for area!\naborting...");
            System.exit(0);
        }
        this.corners = new Position[(Positions.length - 7) / 2];
        for (int i = 0; i < Positions.length - 7; i += 2) {
            this.addPoint((int)Positions[i], (int)Positions[i + 1]);
            this.corners[i / 2] = new Position((int)Positions[i], (int)Positions[i + 1]);
            if (!debug) continue;
            System.out.println("(" + (int)Positions[i] + ";" + (int)Positions[i + 1] + ")");
        }
    }

    protected abstract void SetDefaultValues();

    protected CatastropheArea(double[] Positions) {
        this.type = (int)Positions[Positions.length - 3];
        this.InitializeSpecificValues(Positions);
        this.Positions = Positions;
        this.entry = new Position(Positions[Positions.length - 7], Positions[Positions.length - 6]);
        this.exit = new Position(Positions[Positions.length - 5], Positions[Positions.length - 4]);
        this.wantedgroups = (int)Positions[Positions.length - 2];
        this.locatedgroups = 0;
        this.numtransportgroups = (int)Positions[Positions.length - 1];
        this.assignedtransportgroups = 0;
        if (debug) {
            System.out.println("Entry:(" + this.entry.x + ";" + this.entry.y + ")|Exit:(" + this.exit.x + ";" + this.exit.y + ")\n");
        }
        if (this.wantedgroups < this.numtransportgroups) {
            System.out.println("There can't be more transport groups than total groups, here: transport groups " + this.numtransportgroups + " total " + this.wantedgroups);
            System.exit(0);
        }
        this.SetDefaultValues();
    }

    public double[] getPolygonParams() {
        double[] params = new double[8];
        for (int i = 0; i < this.xpoints.length; ++i) {
            params[2 * i] = this.xpoints[i];
            params[2 * i + 1] = this.ypoints[i];
        }
        return params;
    }

    public void print() {
        System.out.println("Coordinates of CatastropheArea ");
        for (int i = 0; i < this.Positions.length - 7; ++i) {
            System.out.print(this.Positions[i] + ",");
            if (i != this.Positions.length - 8) continue;
            System.out.println("");
        }
        System.out.println("entry " + this.entry.x + " " + this.entry.y + " exit " + this.exit.x + " " + this.exit.y + " type " + this.type + " wanted groups " + this.wantedgroups + " groupsize " + this.groupsize + " minspeed " + this.minspeed + " maxspeed " + this.maxspeed);
    }

    public String VerticesToString() {
        Object represent = new String();
        for (int i = 0; i < this.Positions.length - 7; ++i) {
            Double help = this.Positions[i];
            represent = (String)represent + " " + help.toString();
        }
        return represent;
    }

    public boolean equals(CatastropheArea other) {
        if (this.type != other.type) {
            return false;
        }
        for (int i = 0; i < this.Positions.length - 7; ++i) {
            if (this.Positions[i] == other.Positions[i]) continue;
            return false;
        }
        return true;
    }
}

