/*
 * Decompiled with CFR 0.152.
 */
package bonnmotion;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.StringTokenizer;
import java.util.Vector;

public abstract class App {
    private static boolean printStrace = false;

    protected void parse(String[] args) {
        Object a = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].charAt(0) == '-' && Character.isLetter(args[i].charAt(1)) && a != null) {
                this.parseArg((String)a);
                a = null;
            }
            if (a == null && args[i].charAt(0) != '-') {
                System.out.println("warning: ignoring argument \"" + args[i] + "\"");
                continue;
            }
            a = a == null ? args[i] : (String)a + " " + args[i];
        }
        if (a != null) {
            this.parseArg((String)a);
        }
    }

    protected boolean parseArg(String a) {
        char key = a.charAt(1);
        String val = a.substring(2);
        while (val.length() > 0 && val.charAt(0) == ' ') {
            val = val.substring(1);
        }
        return this.parseArg(key, val);
    }

    protected boolean parseArg(char key, String val) {
        switch (key) {
            case 'D': {
                printStrace = true;
                return true;
            }
        }
        return false;
    }

    public static void exceptionHandler(String _msg, Exception _e) {
        System.out.println();
        System.out.println("Error:");
        System.out.println("\t" + _msg);
        if (_e.getClass() == FileNotFoundException.class) {
            System.out.println("\t" + ((FileNotFoundException)_e).getMessage());
        }
        if (_e.getClass() == NumberFormatException.class) {
            System.out.println("\tArgument " + _e.getMessage() + " is not a number.");
        }
        if (_e.getClass() == RuntimeException.class) {
            System.out.println("\t" + _e.getMessage());
        }
        if (printStrace) {
            System.err.println();
            _e.printStackTrace();
        }
        System.exit(0);
    }

    public abstract void go(String[] var1) throws FileNotFoundException, IOException;

    public static PrintWriter openPrintWriter(String filename) {
        PrintWriter f = null;
        try {
            f = new PrintWriter(new FileOutputStream(filename));
        }
        catch (Exception e) {
            App.exceptionHandler("Error opening " + filename, e);
        }
        return f;
    }

    public static int[] parseIntArray(String arg) {
        StringTokenizer st = new StringTokenizer(arg, ",: ");
        Vector<Integer> rs = new Vector<Integer>();
        while (st.hasMoreTokens()) {
            rs.addElement(Integer.parseInt(st.nextToken()));
        }
        int[] result = new int[rs.size()];
        for (int j = 0; j < result.length; ++j) {
            result[j] = (Integer)rs.elementAt(j);
        }
        return result;
    }

    public static double[] parseDoubleArray(String arg) {
        StringTokenizer st = new StringTokenizer(arg, ",: ");
        Vector<Double> rs = new Vector<Double>();
        while (st.hasMoreTokens()) {
            rs.addElement(Double.parseDouble(st.nextToken()));
        }
        double[] result = new double[rs.size()];
        for (int j = 0; j < result.length; ++j) {
            result[j] = (Double)rs.elementAt(j);
        }
        return result;
    }

    public static String[] parseStringArray(String arg) {
        StringTokenizer st = new StringTokenizer(arg, ",: ");
        Vector<String> rs = new Vector<String>();
        while (st.hasMoreTokens()) {
            rs.addElement(st.nextToken());
        }
        return rs.toArray(new String[0]);
    }

    public static void printHelp() {
        System.out.println("App:");
        System.out.println("\t-D print stack trace");
    }

    public static String[] stringArrayConcat(String[] a, String[] b) {
        String[] c = new String[(a != null ? a.length : 0) + (b != null ? b.length : 0)];
        if (a != null) {
            System.arraycopy(a, 0, c, 0, a.length);
        }
        if (b != null) {
            System.arraycopy(b, 0, c, a != null ? a.length : 0, b.length);
        }
        return c;
    }
}

