/*
 * Decompiled with CFR 0.152.
 */
package bonnmotion;

import bonnmotion.CatastropheArea;
import bonnmotion.Position;

public class AmbulanceParkingPoint
extends CatastropheArea {
    private static final long serialVersionUID = 3251513172589859967L;

    protected AmbulanceParkingPoint(double[] Positions) {
        super(Positions);
        if (debug) {
            System.out.println("AreaType: AmbulanceParkingPoint");
        }
    }

    @Override
    protected void InitializeSpecificValues(double[] Positions) {
        if (Positions.length < 11) {
            System.out.println("Please specify more positions for area!\naborting...");
            System.exit(0);
        }
        this.corners = new Position[(Positions.length - 11) / 2];
        for (int i = 0; i < Positions.length - 11; i += 2) {
            this.addPoint((int)Positions[i], (int)Positions[i + 1]);
            this.corners[i / 2] = new Position((int)Positions[i], (int)Positions[i + 1]);
            if (!debug) continue;
            System.out.println("(" + (int)Positions[i] + ";" + (int)Positions[i + 1] + ")");
        }
        this.borderentry = new Position(Positions[Positions.length - 11], Positions[Positions.length - 10]);
        this.borderexit = new Position(Positions[Positions.length - 9], Positions[Positions.length - 8]);
    }

    @Override
    protected void SetDefaultValues() {
        this.groupsize[0] = 1;
        this.groupsize[1] = 1;
        this.minspeed[0] = 5.0;
        this.maxspeed[0] = 12.0;
        this.minspeed[1] = 1.0;
        this.maxspeed[1] = 2.0;
    }

    @Override
    public void print() {
        for (int i = 0; i < this.Positions.length - 11; ++i) {
            System.out.print(this.Positions[i] + ",");
            if (i != this.Positions.length - 12) continue;
            System.out.println();
        }
        System.out.println("borderentry " + this.borderentry + " borderexit " + this.borderexit + " entry " + this.entry.x + " " + this.entry.y + " exit " + this.exit.x + " " + this.exit.y + " type " + this.type + " wanted groups " + this.wantedgroups + " groupsize " + this.groupsize + " minspeed " + this.minspeed + " maxspeed " + this.maxspeed);
    }

    @Override
    public String VerticesToString() {
        Object represent = new String();
        for (int i = 0; i < this.Positions.length - 11; ++i) {
            Double help = this.Positions[i];
            represent = (String)represent + " " + help.toString();
        }
        return represent;
    }

    @Override
    public boolean equals(CatastropheArea other) {
        if (this.type != other.type) {
            return false;
        }
        for (int i = 0; i < this.Positions.length - 11; ++i) {
            if (this.Positions[i] == other.Positions[i]) continue;
            return false;
        }
        return true;
    }
}

