#!/bin/bash
# >>>>>>>> SUPER USER REQUIRED TO RUN THIS SCRIPT! <<<<<<<<<<<<
# enter super user mode: sudo su

# verion 2.0
  

# =============  USER CONFIG SOURCE FILES ==============
source config_files/user_input.conf
source config_files/functions.sh



# number of clients
num_clients=$lte_clients

# bring up eth2 in case it was down - this takes a few seconds to activate
eth2State=`cat /sys/class/net/eth2/operstate`
if [ "$eth2State" == "down" ]
then
    # echo "eth2 was down, so bring it up"
    ifconfig eth2 up
fi

# set up low level packet filtration 
ethtool -K eth3 sg off
ethtool -K eth3 tso off
ethtool -K eth3 gso off
ethtool -K eth3 gro off

# remove TC queues, in case they are up
./tc/htb reset

# =============  DEFINE OUR LOOPS ==============

# for each fading model
for model in "${fadingModels[@]}"
do

  # for each algorithm
  for algo in "${algoName[@]}"
  do
	   
	 # looping over traffic controllers (e.g., SAP, noTC, and AVIS)
	 for TCValue in "${TCValues[@]}"
	 do 
	 
	    # add a stall weight value to the output folder
	    for stall_Weight in "${stall_Weights[@]}"
	    do
	
	        if [[ $TCValue =~ .*SAP.* ]]
	        then
	            TCValue=SAP-${stall_Weight};
	        
	        fi
	     
	        # for each scheduler value
	        for LTEscheduler in "${LTEschedulers[@]}"
	        do
	                
	           # for each scheduler value
	           for numSegCounter in "${segIndex[@]}"
	           do
	           
	               # for each runIds
                   for runNum in "${runIds[@]}"
	               do 
	               
	                    # save the number of segments to use
	                    numSegment=${numSegments[$numSegCounter]}
	                    segDuration=${segDurations[$numSegCounter]}

                        if [ "$DEBUG" == true ]
                        then
                            echo ""
                            echo "#### Running experimentation for "$model" "$algo" "$TCValue" "$LTEscheduler" "${numSegment}"-segments " ${segDuration}"-sec & run"$runNum" ####"
                            echo ""
                        fi

                        # get the distance for each client
                        ueDistance_list=`set_client_distance $num_clients $lte_clients`
                        # save the values into our array
                        val=0
                        for i in ${ueDistance_list[@]}; do

                            ueDistance[$val]=$i
                            val=$((val+1))
                        done
	                                    
	                    ########## some time variables ############
	            
                        # maxExperimentDuration should cover the video duration, expected stall time and any initialization delays 
                        # let's get the sleep duration for this index
                        clientSleepDurations_index="clientSleepDurations_${runNum}[*]"
                        maxSleepDuration=`IFS=$'\n'; echo "${!clientSleepDurations_index}" | sort -nr | head -n1`
                        maxExperimentDuration=$(echo "scale=3; 1.25 * $numSegment * ${segDurations[$numSegCounter]} + $maxSleepDuration" | bc)

                        if [ "$DEBUG" == true ]
                        then
                            echo "maxExperimentDuration" $maxExperimentDuration ": composed of" $numSegment "segments at" ${segDurations[$numSegCounter]} "seconds each, plus maximum sleep time of" $maxSleepDuration
                        fi

                        # lte duration needs to cover maxExperimentDuration, 2 build_sleep to kill gpac clients                        
                        lte_duration=$(echo "scale=3; $maxExperimentDuration+(2 * $build_sleep)" | bc)

                        # timeOut for end time for clips - this has to be an integer                        
                        timeOut=${maxExperimentDuration%.*}
                        
                        
                        # =============  RUN GPAC over NS3-LTE ==============
                        
                        # branched folder structure
                        # model_output_folder=$trace_output_folder/$algo/${LTEscheduler}/${segDuration}sec/${TCValue}_${model}
                        
                        # new folder structure
                        model_output_folder=$trace_output_folder/$algo/${segDuration}_second/${LTEscheduler}_${model}/${TCValue}
                        run_output_folder=${model_output_folder}/R_${runNum}
                        
                        # delete the trace files
                        rm -rf ./${run_output_folder}/client*
                            
                        # initialise the trace file folders and files
                        for i in `eval echo {1..$num_clients}`
                        do
                            output_folder=${run_output_folder}/client${DEVICE[${i}]}
                            mkdir -p $output_folder
                            echo "" > $output_folder/$output_GPAC_file	                        
                        done
                        
                        # run lte for $build_sleep, i.e. 15 seconds. to make sure all clients receive the GPAc instructions
                        sudo -u user1 dsh -M -g ns3 "cd ~/Code/ns-3-allinone/ns-3-dev; ./waf --run \"scratch/lena-simple-epc-tap-nas --numberOfNodes=$lte_clients --simTime=$build_sleep --distance1=0.0 --distance2=0.0 --distance3=0.0 --distance4=0.0 --distance5=0.0 --distance6=0.0\""  > $trace_output_folder/gpac_run_file-collection.txt &
                        
                        # sleep for 2 seconds to allow time to build the network
		                sleep 2
		                    
		                # run the clients
		                ./GPAC/run_GPAC.sh ${algo} ${runNum} ${trace_output_folder} ${TCValue}_${model} ${timeOut} ${numSegCounter} ${numSegment} ${segDuration} ${run_output_folder}
		                
		                # sleep for $build_sleep to allow GPAC to get the instructions
		                sleep $build_sleep


		                # =============  RUN TO SETUP NS3-LTE ==============
                        plotStartTime=`date '+%s%3N'`
		                # simulate no fading model
		                
                        if [ "$model" == "noFading" ]
                        then

                            if [ "$DEBUG" == true ]
                            then
                              echo "Running Script for ${lte_duration} seconds, using the algorithm ${algo}, TCValue of ${TCValue}, a ${LTEscheduler} scheduler, resource block size of ${RbNum[${rbIndex}]} and no fading model. LTE Parameters --numberOfNodes=$lte_clients --seedValue=${ns3Seed[$((runNum-1))]} --LTEscheduler=${LTEscheduler} --simTime=${lte_duration} --distance1=${ueDistance[0]} --distance2=${ueDistance[1]} --distance3=${ueDistance[2]} --distance4=${ueDistance[3]} --distance5=${ueDistance[4]} --distance6=${ueDistance[5]} --backgroundTraffic=${lte_background_traffic} --bandwidth=${RbNum[${rbIndex}]}"
                            fi
                            # make the output directory
                            mkdir -p ${model_output_folder}/
                            sudo -u user1 dsh -M -g ns3 "cd ~/Code/ns-3-allinone/ns-3-dev; ./waf --run \"scratch/lena-simple-epc-tap-nas --numberOfNodes=$lte_clients --seedValue=${ns3Seed[$((runNum-1))]} --LTEscheduler=${LTEscheduler} --simTime=${lte_duration} --distance1=${ueDistance[0]} --distance2=${ueDistance[1]} --distance3=${ueDistance[2]} --distance4=${ueDistance[3]} --distance5=${ueDistance[4]} --distance6=${ueDistance[5]} --backgroundTraffic=${lte_background_traffic} --bandwidth=${RbNum[${rbIndex}]}\"" > ${run_output_folder}/${LTEscheduler}_run${runNum}_${output_CQI_file} &

                        fi

		                # simulate a fading model with static UEs
                        if [ "$model" == "static" ]
                        then

                            if [ "$DEBUG" == true ]
                            then
                                echo "Running Script for ${lte_duration} seconds, using the algorithm ${algo}, TCValue of ${TCValue}, a ${LTEscheduler} scheduler, resource block size of ${RbNum[${rbIndex}]} and a static fading model. LTE Parameters --numberOfNodes=$lte_clients --seedValue=${ns3Seed[$((runNum-1))]} --LTEscheduler=${LTEscheduler} --simTime=${lte_duration} --distance1=${ueDistance[0]} --distance2=${ueDistance[1]} --distance3=${ueDistance[2]} --distance4=${ueDistance[3]} --distance5=${ueDistance[4]} --distance6=${ueDistance[5]} --backgroundTraffic=${lte_background_traffic} --bandwidth=${RbNum[${rbIndex}]}"
                            fi
		                   # make the output directory
                            mkdir -p ${model_output_folder}/

                            sudo -u user1 dsh -M -g ns3 "cd ~/Code/ns-3-allinone/ns-3-dev; ./waf --run \"scratch/lena-simple-epc-tap-nas --numberOfNodes=$lte_clients --seedValue=${runNum} --LTEscheduler=${LTEscheduler} --simTime=${lte_duration} --distance1=${ueDistance[0]} --distance2=${ueDistance[1]} --distance3=${ueDistance[2]} --distance4=${ueDistance[3]} --distance5=${ueDistance[4]} --distance6=${ueDistance[5]} --useFading=true --backgroundTraffic=${lte_background_traffic} --bandwidth=${RbNum[${rbIndex}]}\""  > ${run_output_folder}/${LTEscheduler}_run${runNum}_${output_CQI_file} &

                        fi

		                # simulate a fading model with mobile UEs
                        if [ "$model" == "mobileP" ]
                        then

                            if [ "$DEBUG" == true ]
                            then
                                    echo "Running Script for ${lte_duration} seconds, using the algorithm ${algo}, TCValue of ${TCValue}, a ${LTEscheduler} scheduler, resource block size of ${RbNum[${rbIndex}]} and a pedestrian mobile fading model. LTE Parameters --numberOfNodes=$lte_clients --seedValue=${ns3Seed[$((runNum-1))]} --LTEscheduler=${LTEscheduler} --simTime=${lte_duration} --distance1=${ueDistance[0]} --distance2=${ueDistance[1]} --distance3=${ueDistance[2]} --distance4=${ueDistance[3]} --distance5=${ueDistance[4]} --distance6=${ueDistance[5]} --backgroundTraffic=${lte_background_traffic} --bandwidth=${RbNum[${rbIndex}]}"
                            fi

                            # make the output directory
                            mkdir -p ${model_output_folder}/

                            sudo -u user1 dsh -M -g ns3 "cd ~/Code/ns-3-allinone/ns-3-dev; ./waf --run \"scratch/lena-simple-epc-tap-nas --numberOfNodes=$lte_clients --seedValue=${runNum} --LTEscheduler=${LTEscheduler} --simTime=${lte_duration} --distance1=${ueDistance[0]} --distance2=${ueDistance[1]} --distance3=${ueDistance[2]} --distance4=${ueDistance[3]} --distance5=${ueDistance[4]} --distance6=${ueDistance[5]} --useFading=true --mobileFading=true --backgroundTraffic=${lte_background_traffic} --bandwidth=${RbNum[${rbIndex}]}\""  > ${run_output_folder}/${LTEscheduler}_run${runNum}_${output_CQI_file} &

                        fi
		
		                # simulate a fading model with mobile UEs
                        if [ "$model" == "mobileV" ]
                        then

                            if [ "$DEBUG" == true ]
                            then
                                echo "Running Script for ${lte_duration} seconds, using the algorithm ${algo}, TCValue of ${TCValue}, a ${LTEscheduler} scheduler, resource block size of ${RbNum[${rbIndex}]} and a vehicular mobile fading model. LTE Parameters --numberOfNodes=$lte_clients --seedValue=${ns3Seed[$((runNum-1))]} --LTEscheduler=${LTEscheduler} --simTime=${lte_duration} --distance1=${ueDistance[0]} --distance2=${ueDistance[1]} --distance3=${ueDistance[2]} --distance4=${ueDistance[3]} --distance5=${ueDistance[4]} --distance6=${ueDistance[5]} --backgroundTraffic=${lte_background_traffic} --bandwidth=${RbNum[${rbIndex}]}"
                            fi

                            # make the output directory
                            mkdir -p ${model_output_folder}/

                            sudo -u user1 dsh -M -g ns3 "cd ~/Code/ns-3-allinone/ns-3-dev; ./waf --run \"scratch/lena-simple-epc-tap-nas --numberOfNodes=$lte_clients --seedValue=${runNum} --LTEscheduler=${LTEscheduler} --simTime=${lte_duration} --distance1=${ueDistance[0]} --distance2=${ueDistance[1]} --distance3=${ueDistance[2]} --distance4=${ueDistance[3]} --distance5=${ueDistance[4]} --distance6=${ueDistance[5]} --useFading=true --mobileFading=true --vehicleFading=true --backgroundTraffic=${lte_background_traffic} --bandwidth=${RbNum[${rbIndex}]}\""  > ${run_output_folder}/${LTEscheduler}_run${runNum}_${output_CQI_file} &

                        fi
		                
                        # give the script enough time to build before running the clients
                        sleep $build_sleep
		                
                        # determine the RNTI numbers per client
                        MAX_RNTIs=`head ./${run_output_folder}/${LTEscheduler}_run${runNum}_${output_CQI_file} -n 150| awk -v a=$lte_clients 'BEGIN{numClients=a; for(i=1; i <= (numClients); i++) client_array[i]=0;} {if($0 ~ "CellId"){client_array[$6]=$8;}} END{for(i=1; i <= (numClients); i++){ printf (client_array[i]) " ";}}'`

                        if [ "$DEBUG" == true ]
                        then
                            echo "MAX_RNTIs" $MAX_RNTIs
                        fi
                        # lets get the max  value and allocate the rates to the correct UE
                        rnti_counter=$num_clients
                        MAX_RNTI=0
                        for i in ${MAX_RNTIs[@]}; do
                            
                            if [ $MAX_RNTI -le $i ]
                            then
                                MAX_RNTI=$i
                            fi
                        done

                        if [ "$DEBUG" == true ]
                        then
                            echo "MAX_RNTI" $MAX_RNTI
                        fi

                        # create rnti array  and initialize it
                        for (( i=1; i<=$MAX_RNTI; i++ ))
                        do
                            rnti_values[$i]=0;
                        done
                        for i in ${MAX_RNTIs[@]}; do
                            rnti_values[$i]=$rnti_counter
                            rnti_counter=$(( $rnti_counter-1 ))
                            
                        done
                        
                        rnti_counter=$num_clients
                        # lets reverse sort and allocate the RNTI values
                        for (( i=1; i<=$MAX_RNTI; i++ ))
                        do
                            # echo "rnti_values[$i] =" ${rnti_values[$i]}
                            if [ ${rnti_values[$i]} -ge 1 ]
                            then
                            
                                RNTI[${rnti_values[$i]}]=$(( ${rnti_counter}+51 ))

                                if [ "$DEBUG" == true ]
                                then
                                    echo "RNTI[${rnti_values[$i]}]=" ${RNTI[${rnti_values[$i]}]} " rnti_values[$i]=" $(( ${rnti_counter}+51 ))
                                fi

                                rnti_counter=$(( $rnti_counter-1 ))
                            fi
                        done
                        
		
                        #run noTC manager
                        if [ "$TCValue" == "noTC" ]
                        then
                            # define a TC rate for the parent queue - 100Mbps
                            notc_rate=100000;
                            ./tc/htb create_parent -r ${notc_rate}
                            if [ "$DEBUG" == true ]
                            then
		               ./tc/htb show
		            fi
			                
                            # give the script enough time to build before running the clients
                            sleep $build_sleep

                            if [ "$DEBUG" == true ]
                            then
                                echo "Don't run the GPAC clients with TC"
                            fi

                            # =============  RUN TO SET UP THE CLIENTS ==============
                            # initialise the activity of only clients that are streaming
                            for i in `eval echo {1..$num_clients}`
                            do
                                if [ "$DEBUG" == true ]
                                then
                                    echo "initialise client" $i
                                fi
                                activityVector[i]=1;
                            done
	                        # reset a finished client counter, when this value reaches the number of clients, then we kill the lte network
	                        finishedClients=0
		                    
                            # establish a max run time for the simulation 
                            elapsedTime=`date '+%s.%3N'`
                            end=$(echo "scale=3; $elapsedTime + $timeOut/1" | bc) 
                            if [ "$DEBUG" == true ]
                            then
                                echo "start at " `date`
                            fi

                            while (( $(echo "$elapsedTime<=$end" | bc -l) )); do 		                    
		                        # check if clients have finished
                                for i in `eval echo {1..$num_clients}`
                                do                                        
                                    # CODE HERE TO GET SEG # FROM CLIENTS
                                    client_file=./${run_output_folder}/client${DEVICE[i]}/$output_GPAC_file
                                    # we use grep to determine if the current number of segments have been received
                                    # if the activity is zero or the client is finished
                                    if [ "${activityVector[i]}" == "0" ] || [ "$(grep -c "segment $numSegment" $client_file)" -ge 2 ]
                                    then        
                                        # update activity for this client to zero only once
                                        if ! [ "${activityVector[i]}" == "0" ]
                                        then

                                            if [ "$DEBUG" == true ]
                                            then
                                                echo ""
                                                echo "client" $i "ip 12.0.0." ${DEVICE[i]} "has completed download, activity set to zero "
                                            fi
                                            activityVector[i]=0;
                                            finishedClients=$(($finishedClients+1));
                                            if [ "${finishedClients}" == "$num_clients" ]
                                            then
                                                if [ "$DEBUG" == true ]
                                                then
                                                    echo "everyone has finished"
                                                fi                                                
                                                # break out of the for loop and the while loop
                                                break 2
                                            fi
                                        fi
                                    fi
                                done
                                elapsedTime=`date '+%s.%3N'`
                            done
		                    
                            if [ "$DEBUG" == true ]
                            then
                                ./tc/htb show
                            fi
                            ./tc/htb reset
                            if [ "$DEBUG" == true ]
                            then
                                ./tc/htb show
                            fi
		                    
#----------------------------------------------------
          #####   ###   #####
          #      #   #  #   #
          ####   #####  ####
             #   #   #  #
          ####   #   #  #
#----------------------------------------------------
                        elif [[ $TCValue =~ .*SAP.* ]]
                        then
                            if [ "$DEBUG" == true ]
                            then
                                echo "Determine values for SAP and TC"
                            fi

                            # =============  SETUP TC FOR THE CLIENTS ==============
                            # number of clients and max_rate of 10Mbps
                            max_lte_rate=$(($initial_per_client_lte_rate * $num_clients))

                            if [ "$DEBUG" == true ]
                            then
                                echo $num_clients "clients"
                                echo "max_lte_rate" $max_lte_rate
                            fi

                            ./tc/htb create -n $num_clients -r $max_lte_rate
                            # ./tc/htb parent_rule -rate $initial_max_lte_rate
                            if [ "$DEBUG" == true ]
                            then
                                ./tc/htb show
                            fi
		                    
                            # =============  RUN SAP ==============

                            # lets update the rep rate with the new encoding rate
                            rep_rate_counter=0
                            # reset the rep_rate list
                            rep_temp_list=();
                            for i in ${rep_rates[@]}; do
                                rep_temp_list[$rep_rate_counter]=$(echo "scale=0; $i*${rep_rate_scale}/1" | bc)

                                if [ "$DEBUG" == true ]
                                then
                                    echo "${rep_temp_list[$rep_rate_counter]}" ${rep_temp_list[$rep_rate_counter]} "$rep_rate_counter" $rep_rate_counter
                                fi
                                
                                rep_rate_counter=$(( $rep_rate_counter+1 ))
                            done

                            if [ "$DEBUG" == true ]
                            then
                                echo "rep_temp_list" ${rep_temp_list[@]}
                                rep_list=$(echo "${rep_temp_list[@]}")
                            fi

                            # output file for SAP/AVIS - no underscore in output name :)
                            solution_output_file=tc/${algo}${model}${sap_output_file}
		
                            # remove old files
                            rm ./myLog.log
                            rm $solution_output_file
        
                            # determine the number of lines to gather from the trace output files
                            tail_count=$(( $(( $probe_time / $sample_time )) * $lte_clients))

                            if [ "$DEBUG" == true ]
                            then
                                echo "number of lines to access from tail -" $tail_count
                            fi

                            # initialise the switchVector - update for smaller number of clients
                            for i in `eval echo {1..$lte_clients}`
                            do
                                if [ "$DEBUG" == true ]
                                then
                                    echo "initialise client" $i
                                fi

                                switchesVector[$i]=0;
                                currentRateVector[i]=$initial_per_client_lte_rate;
                                if [ $i -le $num_clients ]
                                then
                                    # update to 1 from 0, for version 1.3.1
                                    activityFlags[i]=0;
                                    activityStartBoolean[i]=0;
                                else
                                    activityFlags[i]=0;
                                fi
                                # segment duration per client
                                segDurationVector[i]=${segDurations[$numSegCounter]};
                                # client buffer level
                                clientBufferVector[$i]=$initialBuffer;
                                clientBufferTotalVector[$i]=0;
                                
                                bufferTimerVector[$i]=0; 
                                clientBufferCounterVector[$i]=0;                                
                                clientRepRatesVector[i]=$rep_list;# client representation rates                                
                                bufferEstimationInit[i]=false;# a boolean to see if we read the initial segment 3 buffer already                                
                                rep_rate_client_checker[i]=false;# a boolean to see if we read the rep_rate already
                                # define by encoding rate for each client - static for the moment, but maybe dynamic in the future                                
                                max_Rate_Vector=(3000 3000 3000 3000 3000 3000);                                
                                transmitted_byteVector[i]=0;# number of bytes transmitted per client                                
                                reset_byteVector[i]=0;# bytes reset point per client
                                segment_byte_equality=true;
                                client_seg_num_request[i]=0;
                                client_seg_num_receive[i]=0;
                                
                                # buffer estimate vector
                                streamCompleteVector[i]=0;
                                stallSegNumber[i]=0;
                                bufferisEmpty[i]=0;
                                
                                # SAP estimation run times
                                sap_execute_start=0;
                                
                                # set the sap output default values - assuming zero index for rep_rate
                                sap_output="0 0 0 0 0 0"
                                for j in `eval echo {0..$(( $switch_counter_value_AVIS_SAP - 1 ))}`
                                do
                                    declare -A clientSwitch2DVector;
                                    clientSwitch2DVector[$i,$j]=0;
                                    clientSwitch2DCounter[$i]=0;
                                done
                            done
	                        
                            # we terminate the experiment when this counter reaches the number of clients
                            finishedClients=0
                            if [ "$DEBUG" == true ]
                            then
                                echo ""
                                echo "entering bandwidth modification"
                            fi

                            # now wait for a set number of seconds to determine the output
                            # while sleep $[ $maxExperimentDuration + $build_sleep ]; do
                            elapsedTime=`date '+%s.%3N'`
                            end=$(echo "scale=3; $elapsedTime + $timeOut/1" | bc)  
                            while (( $(echo "$elapsedTime<=$end" | bc -l) )); do 
                                echo "ELAPSED TIME $elapsedTime  - END TIME $end  "
                                for i in `eval echo {1..$num_clients}`
                                do
                                    if (( $(echo "${clientBufferVector[$i]}<=0" | bc -l) ))
                                    then
                                        if [ "$DEBUG" == true ]
                                        then
                                            echo "buffer for client" $i "is empty"
                                        fi
                                        clientBufferVector[$i]=0                                                                                  
                                        clientBufferTotalVector[$i]=0.1
                                    else                                        
                                        clientBufferTotalVector[$i]=${clientBufferVector[$i]}
                                    fi
                                done
                                if [ "$DEBUG" == true ]
                                then
                                    echo ""
                                    echo "Start of SAP TIME LOOP - Seconds value - "`date '+%s.%3N'` " End value - "$end
                                fi

                                # get the current lte acheivable rate per RU per client		                        
                                ru_rate=`tail ./${run_output_folder}/${LTEscheduler}_run${runNum}_${output_CQI_file} -n $tail_count | awk -v d="$MAX_RNTIs" -v e=${num_clients} 'BEGIN{ numClients=e; split(d, a, " "); lineCounter=0; for(i in a){ client_array[a[i]]=0;}} {if($0 ~ "RNTI"){ client_array[$4]+=$7; lineCounter++;}} END{ for(i in a){ printf (client_array[a[i]]/(lineCounter/numClients)/1000); if(i < (numClients)){ printf " ";}}}'`

                                if [ "$DEBUG" == true ]
                                then
                                    echo `date '+%H_%M_%S'` "ru rate" $ru_rate
                                fi

                                # ./sap
                                # nUsers                (single value)                  - 3
                                # nQualities            (single value)                  - 10
                                # maxRateVector- (device-specific and can be updated to include network/operator-specific) - kbps - define by encoding rate
                                # defined once from client at the start or updated by the network - static at the moment
                                # maxRateVector - NEW   (N values - based on nUsers)    - 1050 1050 1050
                                # activityFlags        (N values - based on nUsers)    - 1 1 1 - "also known as activityVector"
                                # currentRateVector     (N values - based on nUsers)    - 750 1050 560
                                # ruRateVector          (N values - based on nUsers)    - 185 100 100
                                # switchesVector        (N values - based on nUsers)    - 5 1 0
                                # DeadlineVector - (deadline in sec, should be read from client line and updated as time passes) - buffer value in seconds - shown as "clientBufferVector"
                                # DeadlineVector - NEW  (N values - based on nUsers)    - 10 5 4
                                # initSegRateIndexVector - 1..nQualities "index - 1-based" OR 0 when the call would determine the rate based on an asynchronous trigger (new user segment) - rep_rate index
                                # initSegRateIndexVector - NEW (N values - based on nUsers)    - 0 0 0 - default for first segment
                                # rateExtendedVector    (nQualities values * nUsers)    - 235 375 560 750 1050 1750 2350 3000 3850 5000 235 375 560 750 1050 1750 2350 3000 3850 5000 235 375 560 750 1050 1750 2350 3000 3850 5000
                                # txByteVector - (number of transmitted bytes for current segment. Initialized with GET request and updated based on the number of transmitted in "Kilobytes") - TC
                                # txByteVector - NEW              (N values - based on nUsers)    - 2000 5000 10000

                                # switchingPenalty      (single value)                  - 0.25 - "also known as switchingWeight"
                                # stallWeight - weight for stall probabilty in the objective function
                                # stallWeight - NEW     (single value)                  - 2
                                # totalResources        (single value)                  - 12 RBG
                                # opFile - output file   
                                # example -
                                # ./tc/sap 3 10 185 100 100 1 1 1 750 1050 560 185 100 100 5 1 0 10 5 4 initSegRateIndexVector 235 375 560 750 1050 1750 2350 3000 3850 5000 235 375 560 750 1050 1750 2350 3000 3850 5000 235 375 560 750 1050 1750 2350 3000 3850 5000 750 1050 560 2000 5000 10000 0.25 2 12 output_file
                                current_execute_time=`date '+%s%3N'`                                
                                sap_execute_time=$(( $current_execute_time - $sap_execute_start ))

                                if [ "$DEBUG" == true ]
                                then
                                    echo "current time" `date '+%H_%M_%S.%3N'` ": sap_execute_time " $sap_execute_time
                                fi

                                # if the execution time is less than a mandated period, then sleep for the remaining time
                                if (( $(echo "${sap_execute_time}<${sap_execute_period}" | bc -l) ))
                                then
                                    if [ "$DEBUG" == true ]
                                    then
                                        echo "sleep "${sap_execute_period}" - "${sap_execute_time}
                                    fi
                                    sleep $(echo "scale=3; (${sap_execute_period}-${sap_execute_time})/1000" | bc)                                    
                                else
                                    if [ "$DEBUG" == true ]
                                    then
                                        echo "no sleep SAP execution time of ${sap_execute_time} is greater than ${sap_execute_period}"
                                    fi
                                fi
                                if [ "$DEBUG" == true ]
                                then
                                    echo "starting SAP" `date '+%H_%M_%S.%3N'`
                                fi

                                sap_execute_start=`date '+%s%3N'`
                                
                                cmdText="  $lte_clients $num_rep_rates ${max_Rate_Vector[@]}"
                                for i in `seq 1 $lte_clients`; do cmdText="$cmdText ${activityFlags[i]}"; done 
                                for i in `seq 1 $lte_clients`; do cmdText="$cmdText ${currentRateVector[i]}"; done
                                cmdText="$cmdText $ru_rate"
                                for i in `seq 1 $lte_clients`; do cmdText="$cmdText ${switchesVector[i]}"; done
                                for i in `seq 1 $lte_clients`; do cmdText="$cmdText ${clientBufferTotalVector[i]}"; done
                                cmdText="$cmdText ${sap_output}"
                                for i in `seq 1 $lte_clients`; do cmdText="$cmdText ${clientRepRatesVector[i]}"; done
                                for i in `seq 1 $lte_clients`; do cmdText="$cmdText ${transmitted_byteVector[i]}"; done
                                cmdText="$cmdText ${switch_Weight} ${stall_Weight} ${nLteRbgs[${rbIndex}]} $solution_output_file"


                                echo "./tc/ssap2 $(( $current_execute_time - $plotStartTime )) $cmdText"
                                ./tc/ssap2 $cmdText                                
                                
                                if [ "$DEBUG" == true ]
                                then
                                    echo "leaving SAP " `date '+%H_%M_%S.%3N'`
                                fi                                
                                if [ -f $solution_output_file ] 
                                then                                       
                                    sap_output=`cat $solution_output_file`; # get the sap output
                                    sap_output_first_val=`echo $sap_output | awk '{print $1}'`; # get the first value in the output list
                                    if [ "$DEBUG" == true ]
                                    then
                                        echo "sap_output_first_val" $sap_output_first_val
                                    fi

                                    # only update if the sap_output file provides rates
                                    if ! [ "$sap_output_first_val" == "-1" ]
                                    then
                                        total_rate=0                                        
                                        # variables for the total parent rate
                                        parent_rate=0
                                        parent_ceil_rate=0        
                                        # update the per client bandwidth allocation
                                        for i in `eval echo {1..$num_clients}`
                                        do
                                            if [ "$DEBUG" == true ]
                                            then                                                
                                                echo "BW allocation client" $i "ip 12.0.0." ${DEVICE[i]}
                                            fi
                                            # CODE HERE TO GET SEG # FROM CLIENTS
                                            client_file=./${run_output_folder}/client${DEVICE[i]}/$output_GPAC_file                                            
                                            
                                            if [ "${activityFlags[i]}" == "0" ] && [ "$(grep -c "Opening URL http" $client_file)" -ge 1 ] && [ "${activityStartBoolean[i]}" == "0" ]
                                            then
                                                # client has started requesting --> set activity to 1
                                                if [ "$DEBUG" == true ]
                                                then
                                                    echo "Client has made a request: Set activity vector for client" $i "to 1"
                                                fi
                                                activityFlags[i]=1;
                                                bufferTimerVector[$i]=`date '+%s.%3N'`                                                
                                                activityStartBoolean[i]=1;
                                                
                                                # we can use grep to determine the if the current number of segments have been received
                                                # if the activity is zero or the client is finished
                                            elif [ "${activityFlags[i]}" == "0" ] || [ "$(grep -c " segment $numSegment" $client_file)" -ge 2 ]; then		                                        
                                                # reset activity flag for this client to zero
                                                if ! [ "${activityFlags[i]}" == "0" ]
                                                then
                                                    if [ "$DEBUG" == true ]; then
                                                        echo "client" $i "has completed download, activity set to zero "
                                                    fi
                                                    activityFlags[i]=0;                                                    
                                                    ./tc/htb delete_child -ip ${DEVICE[i]} ; # delete child queue                                                    
                                                    finishedClients=$(($finishedClients+1)); # increment our finished client counter                                                    
                                                    switchesVector[$i]=0; # reset switch vector to zero 
                                                    
                                                    
                                                    if [ "${finishedClients}" == "$num_clients" ]; then
                                                        # stop experiment if all clients have finished
                                                        if [ "$buffer_estimate" == true ]
                                                        then
                                                            # break out of the for loop only, we still need to calculate the buffer on the last loop
                                                            break 1
                                                        else
                                                            # break out of the for loop and the while loop
                                                            break 2
                                                        fi
                                                    fi
                                                fi
                                            else                                            
                                                max_rep_rate=`echo ${clientRepRatesVector[i]} | awk '{print $10}'`; # first get the maximum rep rate                                                    
                                                cur_rate_index=`echo $sap_output | awk -v a=$i 'BEGIN{ myIndex=a} {print $myIndex}'`; # then get the current allocated rate index - returned by sap                                                    
                                                next_rate_index=$(($cur_rate_index+1 )); # increase the zero-based index to a one-based index
                                                prev_rate_value=${currentRateVector[i]}; # save the current allocated rate for this client
                                                # next get the rep rate based on this index
                                                currentRateVector[i]=`echo ${clientRepRatesVector[i]} | awk -v a=$next_rate_index 'BEGIN{ next_rate=a}{print $next_rate}'`;                                                    
                                                parent_rate=$(($parent_rate+${currentRateVector[i]})); # update the parent code                                                
                                                total_rate=$(( $total_rate + ${currentRateVector[i]} )); # update the total rate
                                                if [ "${clientSwitch2DCounter[$i]}" == "$(( $switch_counter_value_AVIS_SAP - 1 ))" ] 
                                                then
                                                    clientSwitch2DCounter[$i]=0;	                                                
                                                else
                                                    # otherwise increment the 'j' counter
                                                    clientSwitch2DCounter[$i]=$(( ${clientSwitch2DCounter[$i]}+1 ))
                                                fi
                                                # if the client is at the same rate, there is no need to update TC
                                                if [ "${currentRateVector[i]}" == "$prev_rate_value" ]; then
                                                    if [ "$DEBUG" == true ]; then
                                                        echo "client at same rate," $prev_rate_value "not updating TC"
                                                    fi
                                                    # we need to check if we are at the highest rate for the parent ceiling
                                                    if ! [ "${currentRateVector[i]}" == "$max_rep_rate" ]
                                                    then                                                            
                                                        # if not at the max get the next rate up - zero index list
                                                        value=`get_rep_rate_index ${currentRateVector[i]} "${clientRepRatesVector[i]}"`	                                                
                                                        next_rep_rate=`echo ${clientRepRatesVector[i]} | awk -v a=$value 'BEGIN{ val=a; val=val+2;}{print $val}'`
                                                        if [ "$DEBUG" == true ]; then
                                                            echo "value" $value  "currentRateVector" ${currentRateVector[i]} "clientRepRatesVector" ${clientRepRatesVector[i]}
                                                            echo "next_rep_rate" $next_rep_rate
                                                        fi
                                                        max_rate=$(( $((${currentRateVector[i]} + $next_rep_rate )) / 2))
                                                    else
                                                        # the max rate ceil is 1.25
                                                        max_rate=$(echo "scale=0; ${currentRateVector[i]}*1.25/1" | bc)
                                                    fi                                                    
                                                    clientSwitch2DVector[$i,${clientSwitch2DCounter[$i]}]=0;# increase the switch value
                                                    parent_ceil_rate=$(($parent_ceil_rate+$max_rate)); # update the parent ceil rate
		                                            
                                                # if we are now at the highest rate then save this
                                                elif [ "${currentRateVector[i]}" == "$max_rep_rate" ]; then        
                                                    max_rate=$(echo "scale=0; ${currentRateVector[i]}*1.25/1" | bc)
                                                    if [ "$DEBUG" == true ]; then
                                                        echo "Switch to highest rate" ${currentRateVector[i]}
                                                    fi
                                                    parent_ceil_rate=$(($parent_ceil_rate+$max_rate)); # update the parent ceil rate
                                                    ./tc/htb rules -ip ${DEVICE[i]} -min ${currentRateVector[i]} -max $max_rate; # update child queue
                                                    clientSwitch2DVector[$i,${clientSwitch2DCounter[$i]}]=1;# increase the switch value
                                                else
                                                    # get the next rate up - zero index list
                                                    value=`get_rep_rate_index ${currentRateVector[i]} "${clientRepRatesVector[i]}"`
                                                    if [ "$DEBUG" == true ]; then
                                                        echo "Switch to rate" ${currentRateVector[i]}
                                                    fi

                                                    # get the value of the next index up - assume zero-index input and 1-index output
                                                    next_rep_rate=`echo ${clientRepRatesVector[i]} | awk -v a=$value 'BEGIN{ val=a; val=val+2;}{print $val}'`
                                                    max_rate=$(( $((${currentRateVector[i]} + $next_rep_rate )) / 2)); # max_rate 
                                                    parent_ceil_rate=$(($parent_ceil_rate+$max_rate)); # update the parent ceil rate
                                                    ./tc/htb rules -ip ${DEVICE[i]} -min ${currentRateVector[i]} -max $max_rate; # update child queue
                                                    clientSwitch2DVector[$i,${clientSwitch2DCounter[$i]}]=1;# increase the switch value
                                                fi
		                                        
                                                # we need to sum up the clientSwitches
                                                switchesVector[$i]=0;
                                                for j in `eval echo {0..$(( $switch_counter_value_AVIS_SAP - 1 ))}`; do
                                                    switchesVector[$i]=$(( ${switchesVector[$i]} + ${clientSwitch2DVector[$i,$j]} ));
                                                done
                                            fi

                                        done
                                        # update the tc parent with a lower overall max_rate
                                        if [ "$DEBUG" == true ]; then
                                            echo "parent_rate" $parent_rate
                                            echo "parent_ceil_rate" $parent_ceil_rate
                                        fi  
                                        # only update if clients are streaming
                                        if (( $(echo "${parent_rate}>=1" | bc -l) )) ; then
                                            ./tc/htb parent_rule -rate $parent_rate -max $parent_ceil_rate
                                        fi
                                    fi
                                fi
		                        
                                # =============  SAP BYTES TRANSMITTED ==============
                                # determine transmitted bytes per client 
                                transmitted_byte_information=`./tc/htb bytes_sent`
                                
                                for i in `eval echo {1..$num_clients}`
                                do  
                                    # only update if the client is actually running
                                    if [ "${activityFlags[i]}" == "1" ] 
                                    then		                            
                                        # determine the number of bytes transmitted
                                        transmitted_information=`echo -e "$transmitted_byte_information" | awk -v RNTI=${DEVICE[i]} 'BEGIN{rnti=RNTI; setBytes=0;}{if(FNR > 0){if(setBytes==1){print $0; setBytes=0; } if($0 ~ "class htb 1:"rnti){setBytes=1;}}}'`

                                       
                                        # get the number of bytes transmitted so far for this client/queue
                                        transmittedBytes=`echo $transmitted_information | awk '{print $2}'`
                                        # CODE HERE TO GET DETAILS FROM CLIENTS
                                        client_file=./${run_output_folder}/client${DEVICE[i]}/$output_GPAC_file

                                        # get values from the client file - we need to work from the end of the line, as some added buffer lines have no return carriages
                                        requestStartTime=`awk 'BEGIN{segRequestTime=0; segRequestNumber=0; segArrivalTime=0; segArrivalNumber=0;} {if($0 ~ "HTTP Sending request for segment "){ segRequestNumber=$(NF-3); segRequestTime=$NF;} if($0 ~ "Downloaded segment "){ segArrivalNumber=$(NF-12); segArrivalTime=$(NF-9); }} END{printf segRequestNumber " " segRequestTime " " segArrivalNumber " " segArrivalTime;}' $client_file`;                                        
                                        # seperate the returned values into time and segment number
                                        requestSegStartValue=`echo $requestStartTime | awk '{print $1}'`
                                        requestSegReceiveValue=`echo $requestStartTime | awk '{print $3}'`     
                                        echo "CLIENT $i: DEBUG $requestStartTime"                                   
                                        # if the segment numbers are the same, or if both request and reveice seg number have increased, then
                                        if [ "$requestSegStartValue" == "$requestSegReceiveValue" ] || [ "${client_seg_num_request[i]}" -lt "$requestSegStartValue" ] && [ "${client_seg_num_receive[i]}" -lt "$requestSegReceiveValue" ]
                                        then                                        
                                            # store the request and receive seg numbers
                                            client_seg_num_request[i]=$requestSegStartValue;
                                            client_seg_num_receive[i]=$requestSegReceiveValue;                                        
                                            # we need to remember incase this is not the first time we checked for this equality
                                            if [ "$segment_byte_equality" == true ]; then                                                
                                                # set the reset bytes value
                                                reset_byteVector[i]=$transmittedBytes;
                                                transmitted_byteVector[i]=0;
                                                # reset the segment_byte_equality to false
                                                segment_byte_equality=false                                                
                                                if [ "$DEBUG" == true ]; then
                                                    echo "reset the bytes transmitted for segment "$requestSegStartValue" and "$requestSegReceiveValue
                                                fi
                                            else
                                                # this is how many bytes have been transmitted since last request
                                                transmitted_bytes_now=$(( $transmittedBytes - ${reset_byteVector[i]} ))                                                
                                                if [ "$DEBUG" == true ]; then
                                                    echo "we are here but assume nothing transmitted" $transmitted_bytes_now
                                                fi

                                            fi
                                            
                                        # if the segment numbers are different, and we have not had incremetnal increase in both request and receive, then
                                        else
                                            # we only want to start this when we receive the first segment
                                            if [ "$requestSegStartValue" -ge "1" ]
                                            then
                                                client_seg_num_request[i]=$requestSegStartValue;# store the number of this request segment
                                                # this is how many bytes have been transmitted since last request - value in kilobytes
                                                transmitted_byteVector[i]=$(( $(( $transmittedBytes - ${reset_byteVector[i]} )) / 1000 ))
                                                segment_byte_equality=true; # reset the segment_byte_equality to true
                                                
                                                if [ "$DEBUG" == true ]; then
                                                    echo "bytes transmitted" ${transmitted_byteVector[i]} "for segment "$requestSegStartValue" and "$requestSegReceiveValue
                                                fi
                                            fi
                                        fi
                                    fi
                                done
		                        
		                        
                                # =============  SAP BUFFER AND REP_RATE ESTIMATIONS ==============
                                # let's determine the client metrics
                                for i in `eval echo {1..$num_clients}`
                                do
		                        
                                    if [ "$DEBUG" == true ]; then
                                        echo ""
                                        echo "BUFFER client" $i "ip 12.0.0."${DEVICE[i]}
                                    fi

                                    # only update if the client is actually running
                                    if [ "${activityFlags[i]}" == "1" ] || [ "$buffer_estimate" == true ]; then    
                                        # CODE HERE TO GET DETAILS FROM CLIENTS
                                        client_file=./${run_output_folder}/client${DEVICE[i]}/$output_GPAC_file
                                                
                                        # 1.    client buffer level 
                                        if [ "$buffer_estimate" == true ]; then                                            
                                            if  [ "$(grep -c "segment 1 at " $client_file)" -ge 2 ]; then 
                                                if [ "${bufferEstimationInit[i]}" == false ]; then
                                                    # step 1 - initialize playout start time                                                        
                                                    playerStartTime[$i]=`awk 'BEGIN{segTime=0; segNumber=0;} {if($0 ~ "Downloaded segment 1 at "){ segTime=$(NF-9); segNumber=$(NF-12);}} END{printf segTime " " segNumber;}' $client_file`;
                                                    playerSegStartTime[$i]=`echo ${playerStartTime[$i]} | awk '{print $1}'`
                                                    playerSegStartNumber[$i]=`echo ${playerStartTime[$i]} | awk '{print $2}'`                                                     
                                                    playerSegStartTime_OurTime[$i]=`date '+%s.%3N'`;
                                                    if [ "$DEBUG" == true ]; then
                                                        echo "playerSegStartTime" ${playerSegStartTime[$i]} " with playerSegStartNumber" ${playerSegStartNumber[$i]}" and playerSegStartTime_OurTime" ${playerSegStartTime_OurTime[$i]}
                                                    fi                                                        
                                                    bufferEstimationInit[$i]=true; # so we don't come in here again                                                        
                                                fi
                                                        
                                                # step 2 - get the time the last segment was received
                                                playerDownloadValues[$i]=`awk 'BEGIN{segTime=0; segNumber=0;} {if($0 ~ "Downloaded segment "){ segTime=$(NF-9); segNumber=$(NF-12)}} END{printf segTime " " segNumber;}' $client_file`;
                                                if ! [ -z "${playerDownloadValues[$i]}" ]; then   # operate only on valid values (read/write issues)
                                                    if [ "${streamCompleteVector[i]}" == "0" ]; then                                                        
                                                        playerSegCurrentTime[$i]=`echo ${playerDownloadValues[$i]} | awk '{print $1}'`                                                            
                                                        playerSegCurrentNumber[$i]=`echo ${playerDownloadValues[$i]} | awk '{print $2}'`
                                                        if [ "${playerSegCurrentNumber[$i]}" == "$numSegment" ]; then
                                                            streamCompleteVector[$i]=1
                                                            if [ "$DEBUG" == true ]; then
                                                                echo "client has received all segments"
                                                            fi                                                                
                                                        fi
                                                                
                                                                                                                            
                                                        # step 3 - estimate buffer level 
                                                        totalSegmentTime[$i]=$(( ${segDurationVector[$i]} * $(( ${playerSegCurrentNumber[$i]} - ${stallSegNumber[$i]} )) ));
                                                                                                                   
                                                        # subtract time since playout started, based on this machines time frame
                                                        elapsedTime=`date '+%s.%3N'`
                                                        PlayerTotalTime[$i]=$(echo "scale=3; $elapsedTime - ${playerSegStartTime_OurTime[$i]}/1" | bc)  
                                                        echo "current time" $elapsedTime " - start Time" ${playerSegStartTime_OurTime[$i]} " = PlayerTotalTime "${PlayerTotalTime[i]}                                                           
                                                        # gives estimated buffer level
                                                        estimatedPlayerBuffer[$i]=$( echo "${totalSegmentTime[$i]} - ${PlayerTotalTime[$i]}" | bc );      
                                                        if [ "$DEBUG" == true ]; then
                                                            echo "playerSegCurrentTime" ${playerSegCurrentTime[$i]} " with playerSegCurrentNumber" ${playerSegCurrentNumber[$i]} " and totalSegmentTime "${totalSegmentTime[$i]}
                                                            echo "current time" $elapsedTime " - start Time" ${playerSegStartTime_OurTime[$i]} " = PlayerTotalTime "${PlayerTotalTime[i]}
                                                            echo "estimatedPlayerBuffer "${estimatedPlayerBuffer[$i]}
                                                        fi
                                                        # ****************** update stall information ******************  
                                                        if (( $(echo "${estimatedPlayerBuffer[$i]}<=0" | bc -l) )); then # negative buffer!
                                                            estimatedPlayerBuffer=0;
                                                            bufferisEmpty[$i]=1;
                                                        fi                                                        
                                                        
                                                        if (( $(echo "${bufferisEmpty[$i]}==1" | bc -l) )); then
                                                            if [ "$DEBUG" == true ]; then
                                                                echo "buffer depleted with playerStallSegCurrentNumber ${playerStallSegCurrentNumber[$i]}<${playerSegCurrentNumber[$i]} playerSegCurrentNumber"
                                                            fi
                                                            if (( $(echo "${playerStallSegCurrentNumber[$i]}<${playerSegCurrentNumber[$i]}" | bc -l) )); then
                                                                # playout resumed after a stall 
                                                                playerSegStartTime_OurTime[$i]=`date '+%s.%3N'`; # get the time in our world  
                                                                stallSegNumber[$i]=${playerStallSegCurrentNumber[$i]}; # set the number of segments to ignore due to stall
                                                                if [ "$DEBUG" == true ]; then
                                                                    echo "stall occured at " ${playerStallSegCurrentNumber[$i]} "--> reset playerSegStartTime_OurTime" ${playerSegStartTime_OurTime[$i]}  "set segment stall occured at "${stallSegNumber[$i]}
                                                                fi
                                                                bufferisEmpty[$i]=0; # reset stall flag
                                                            fi
                                                        else                                                        
                                                            playerStallSegCurrentNumber[$i]=${playerSegCurrentNumber[$i]} # just save this value for the next loop, if there was no stalls
                                                        fi
                                                        clientBufferVector[$i]=${estimatedPlayerBuffer[$i]}
                                                    else
                                                        if [ "$DEBUG" == true ]; then
                                                            echo "all segments downloaded"
                                                        fi
                                                    fi                                                    
                                                else
                                                    if [ "$DEBUG" == true ];then
                                                        echo "Warning: file read issue"
                                                    fi
                                                fi
                                            else # initial buffering phase 
                                                if [ "${activityFlags[i]}" == "1" ]; then 
                                                    elapsedTime=`date '+%s.%3N'`
                                                    bufferReduction=$(echo "scale=3; $elapsedTime - ${bufferTimerVector[$i]}/1" | bc) 
                                                    clientBufferVector[$i]=$(echo "scale=3; ${clientBufferVector[$i]} - $bufferReduction/1" | bc)                                                
                                                    bufferTimerVector[$i]=$elapsedTime;        
                                                fi                                            
                                            fi
                                        elif [ "$buffer_estimate" == false ] 
                                        then
                                            if [ "$(grep -c "stall_dur:" $client_file)" -ge 1 ]; then 
                                                # get the buffer value from the client
                                                bufferValue=`awk 'BEGIN{bufferValue=0;} {if($0 ~ "Current Buffer"){ bufferValue=$(NF-2)}} END{printf bufferValue/1000;}' $client_file`;

                                                if [ "$DEBUG" == true ]; then
                                                    echo "bufferValue" $bufferValue
                                                    echo "clientBufferCounterVector[$i]" ${clientBufferCounterVector[$i]}
                                                    echo "before - {bufferTimerVector[$i]}" ${bufferTimerVector[$i]}
                                                fi

                                                # if the value are the same, no new segment has been received, so reduce client buffer
                                                if [ "$bufferValue" == "${clientBufferCounterVector[$i]}" ] 
                                                then                                                    
                                                    # determine how much the buffer has reduced since the last time we came through
                                                    elapsedTime=`date '+%s.%3N'`
                                                    bufferReduction=$(echo "scale=3; $elapsedTime - ${bufferTimerVector[$i]}/1" | bc) 
                                                    bufferTimerVector[$i]=$elapsedTime;
                                                    if [ "$DEBUG" == true ]
                                                    then
                                                        echo "bufferReduction" $bufferReduction
                                                        echo "after - {bufferTimerVector[$i]}" ${bufferTimerVector[$i]}
                                                        echo "same as - SECONDS" $elapsedTime
                                                    fi
                                                    clientBufferVector[$i]=$(echo "scale=3; ${clientBufferVector[$i]} - $bufferReduction/1" | bc) 
                                                else
                                                    if [ "$DEBUG" == true ]; then
                                                        echo "reset the buffer"
                                                    fi
                                                    clientBufferVector[$i]=$bufferValue
                                                    clientBufferCounterVector[$i]=$bufferValue
                                                    bufferTimerVector[$i]=`date '+%s.%3N'`;
                                                fi

                                                if [ "$DEBUG" == true ]
                                                then
                                                    echo "Buffer Level is "${clientBufferVector[$i]}" at ip 12.0.0."${DEVICE[$i]};
                                                fi
                                            else 
                                                # update buffer level based on elapsed time and store last update time 
                                                elapsedTime=`date '+%s.%3N'`
                                                bufferReduction=$(echo "scale=3; $elapsedTime - ${bufferTimerVector[$i]}/1" | bc) 
                                                clientBufferVector[$i]=$(echo "scale=3; ${clientBufferVector[$i]} - $bufferReduction/1" | bc)	                                            
                                                bufferTimerVector[$i]=$elapsedTime;	                                            
                                                if [ "$DEBUG" == true ]; then
                                                    echo "buffer Reduced by " $bufferReduction to ${clientBufferVector[$i]}
                                                fi
                                            fi
                                        fi                              
                                        # 2.    client representation rates - no need to cover estimated as this is the default value
                                        if [ "${rep_rate_client_checker[i]}" == false ] && [ "$(grep -c "Rates: " $client_file)" -ge 1 ] &&  [ "$rep_rate_estimate" == false ]
                                        then
                                            if [ "$DEBUG" == true ]
                                            then
                                                echo "check client representation rates ";
                                            fi
		                                    
                                            # get client rep rate
                                            clientRepRatesVector[i]=`awk -v scaleRate=${rep_rate_scale} 'BEGIN{segTime=0;} {if($0 ~ "Rates: "){ printf("%d %d %d %d %d %d %d %d %d %d\n", ($3/1000)*scaleRate, ($4/1000)*scaleRate, ($5/1000)*scaleRate, ($6/1000)*scaleRate, ($7/1000)*scaleRate, ($8/1000)*scaleRate, ($9/1000)*scaleRate, ($10/1000)*scaleRate, ($11/1000)*scaleRate, ($12/1000)*scaleRate);}} END{}' $client_file`;
		                                    
                                            # boolean to make sure we receive all the rates
                                            rate_estimate=true;
		                                    
                                            # check the value for each rate
                                            for j in `eval echo {1..$num_rep_rates}`
                                            do
                                                # get the current rate
                                                currentRate=`echo ${clientRepRatesVector[$i]} | awk -v val=$j 'BEGIN{indexVal=val}{}END{print $indexVal}'`
                                                
                                                # if any rate is less than 1
                                                if (( $(echo "${currentRate}<=1" | bc -l) ))
                                                then
                                                    if [ "$DEBUG" == true ]
                                                    then
                                                        echo "Warning: rate" $j "was not received from file, possible I/O issue"
                                                    fi
                                                    rate_estimate=false;
                                                fi
                                            done
		                                    
                                            # if rate_estimate is true then we received all the rates, so no need to come here and check again
                                            if [ "${rate_estimate}" == true  ]
                                            then
                                                # so we don't come in here again
                                                rep_rate_client_checker[i]=true;
                                                if [ "$DEBUG" == true ]
                                                then
                                                    echo "Representation rate is "${clientRepRatesVector[i]}" at ip 12.0.0."${RNTI[i]};
                                                fi
                                            else
                                                # lets keep the estimated rate until we have all of the actual rates - I/O read/write issues
                                                # we will get these rates the next time we run through
                                                clientRepRatesVector[i]=$rep_list;
                                            fi       
                                        fi   
                                    fi
		                        
                                done
                                if [ "$DEBUG" == true ]; then
                                    echo ""
                                    echo "End of SAP TIME LOOP - "`date '+%s.%3N'` " End value - "$end
                                    echo ""
                                fi
                                if [ "$buffer_estimate" == true ]
                                then
                                    # if all clients have finished
                                    if [ "${finishedClients}" == "$num_clients" ]
                                    then
                                        break 1
                                    fi
                                fi
                                elapsedTime=`date '+%s.%3N'`    
                            done

                            if [ "$DEBUG" == true ]
                            then
                                echo ""
                                echo "End of TOTAL TIME LOOP -"`date '+%s.%3N'` " End value - "$end
                                echo ""
                            fi

                            # remove queues
                            if [ "$DEBUG" == true ]
                            then
                                ./tc/htb show
                            fi  
                            ./tc/htb reset
		                    
                            if [ "$DEBUG" == true ]
                            then
                                ./tc/htb show
                            fi
	                   
#----------------------------------------------------
          ###### #       # ########  ########
          #    #  #     #     #      #
          ######   #   #      #      #######
          #    #    # #       #            #
          #    #     #     ######## #######
#----------------------------------------------------

                        elif [ "$TCValue" == "AVIS" ]
                        then

                            if [ "$DEBUG" == true ]
                            then
                                echo "Determine values for AVIS and TC"
                            fi

                            # =============  SETUP TC FOR THE CLIENTS ==============
                            # number of clients and max_rate of 10Mbps
                            max_lte_rate=$(($initial_per_client_lte_rate * $num_clients))
                            if [ "$DEBUG" == true ]
                            then
                                echo $num_clients "clients"
                                echo "max_lte_rate" $max_lte_rate
                            fi
                            ./tc/htb create -n $num_clients -r $max_lte_rate
                            # ./tc/htb parent_rule -rate $initial_max_lte_rate
                            if [ "$DEBUG" == true ]
                            then
                                ./tc/htb show
                            fi
                            
                            # give the lte script enough time to build before running the clients
                            sleep $build_sleep

                            # =============  RUN AVIS ==============
        
                            # output file for AVIS - no underscore in output name :)
                            solution_output_file=tc/${algo}${model}${avis_output_file}
        
                            # remove old files
                            rm ./myLog.log
                            rm $solution_output_file
        
                            # determine the number of lines to gather from the trace output files
                            tail_count=$(( $(( $probe_time / $sample_time )) * $lte_clients))

                            if [ "$DEBUG" == true ]
                            then
                                echo "number of lines to access from tail -" $tail_count
                            fi

                            # initialise the switchVector - updated for smaller number of clients
                            for i in `eval echo {1..$lte_clients}`
                            do

                                if [ "$DEBUG" == true ]
                                then
                                    echo "initialise client" $i
                                fi
                                switchesVector[$i]=0;
                                currentRateVector[i]=$initial_per_client_lte_rate;
                                if [ $i -le $num_clients ]
                                then
                                    activityFlags[i]=0;
                                    activityStartBoolean[i]=0;
                                else
                                    activityFlags[i]=0;
                                fi
                                for j in `eval echo {0..$(( $switch_counter_value_AVIS_SAP - 1 ))}`
                                do
                                    # this may be needed to create the association in bash
                                    declare -A clientSwitch2DVector;
                                    clientSwitch2DVector[$i,$j]=0;
                                    clientSwitch2DCounter[$i]=0;
                                done
		                        
                                # AVIS estimation run times
                                avis_execute_start=0;
                                avis_execute_end=0;
                                
                            done
	                        
                            # define a finished client counter, when this value reaches the number of clients, then we kill the lte network
                            finishedClients=0

                            if [ "$DEBUG" == true ]; then
                                echo ""
                                echo "entering bandwidth modification"
                            fi
                            elapsedTime=`date '+%s.%3N'`
                            end=$(echo "scale=3; $elapsedTime + $timeOut/1" | bc) 
                            while (( $(echo "$elapsedTime<=$end" | bc -l) )); do 

                                if [ "$DEBUG" == true ]
                                then
                                    echo ""
                                    echo "Start of AVIS TIME LOOP - "$elapsedTime " End value - "$end
                                fi      
                                # new ru rate - based on passed in RNTI values sorted by closest distance to base station
                                ru_rate=`tail ./${run_output_folder}/${LTEscheduler}_run${runNum}_${output_CQI_file} -n $tail_count | awk -v d="$MAX_RNTIs" -v e=${num_clients} 'BEGIN{ numClients=e; split(d, a, " "); lineCounter=0; for(i in a){ client_array[a[i]]=0;}} {if($0 ~ "RNTI"){ client_array[$4]+=$7; lineCounter++;}} END{ for(i in a){ printf (client_array[a[i]]/(lineCounter/numClients)/1000); if(i < (numClients)){ printf " ";}}}'`

                                if [ "$DEBUG" == true ]
                                then
                                    echo `date '+%H_%M_%S'` "ru rate" $ru_rate
                                fi

                                # ./avis 
                                # nUsers                (single value)                  - 3
                                # nQualities            (single value)                  - 10
                                # activityFlags        (N values - based on nUsers)    - 1 1 1
                                # currentRateVector     (N values - based on nUsers)    - 750 1050 560
                                # ruRateVector          (N values - based on nUsers)    - 185 100 100
                                # switchesVector        (N values - based on nUsers)    - 5 1 0
                                # rateExtendedVector    (nQualities values * nUsers)    - 235 375 560 750 1050 1750 2350 3000 3850 5000 235 375 560 750 1050 1750 2350 3000 3850 5000 235 375 560 750 1050 1750 2350 3000 3850 5000
                                # switchingPenalty      (single value)                  - 0.1
                                # totalResources        (single value)                  - 24
                                # opFile - output file                                  - output_file
                                # example -
                                # ./tc/avis 3 10 1 1 1 750 1050 560 185 100 100 5 1 0 235 375 560 750 1050 1750 2350 3000 3850 5000 235 375 560 750 1050 1750 2350 3000 3850 5000 235 375 560 750 1050 1750 2350 3000 3850 5000 0.1 24 output_file

                                if [ "$DEBUG" == true ]
                                then
                                    echo "current time" `date '+%H_%M_%S.%3N'`
                                fi
                                current_execute_time=`date '+%s%3N'`
                                avis_execute_time=$(( $current_execute_time - $avis_execute_start ))

                                if [ "$DEBUG" == true ]
                                then
                                    echo "avis_execute_time " $avis_execute_time
                                fi
                                if (( $(echo "${avis_execute_time}<${sap_execute_period}" | bc -l) ))
                                then

                                    if [ "$DEBUG" == true ]
                                    then
                                        echo "sleep "${avis_execute_period}" - "${avis_execute_time}
                                    fi
                                    sleep $(echo "scale=3; (${sap_execute_period}-${avis_execute_time})/1000" | bc)
                                else
                                    if [ "$DEBUG" == true ]
                                    then
                                        echo "no sleep avis execution time of ${avis_execute_time} is greater than ${sap_execute_period}"
                                    fi
                                fi

                                if [ "$DEBUG" == true ]
                                then
                                    echo "starting AVIS " `date '+%H_%M_%S.%3N'`
                                fi

                                avis_execute_start=`date '+%s%3N'`

                                echo "./tc/cavis $(( $avis_execute_start - $plotStartTime )) $lte_clients $num_rep_rates ${activityFlags[1]} ${activityFlags[2]} ${activityFlags[3]} ${activityFlags[4]} ${activityFlags[5]} ${activityFlags[6]} ${currentRateVector[1]} ${currentRateVector[2]} ${currentRateVector[3]} ${currentRateVector[4]} ${currentRateVector[5]} ${currentRateVector[6]} $ru_rate ${switchesVector[1]} ${switchesVector[2]} ${switchesVector[3]} ${switchesVector[4]} ${switchesVector[5]} ${switchesVector[6]} $rep_list $rep_list $rep_list $rep_list $rep_list $rep_list 0.1 ${nLteRbgs[${rbIndex}]} $solution_output_file"

                                ./tc/cavis $lte_clients $num_rep_rates ${activityFlags[1]} ${activityFlags[2]} ${activityFlags[3]} ${activityFlags[4]} ${activityFlags[5]} ${activityFlags[6]} ${currentRateVector[1]} ${currentRateVector[2]} ${currentRateVector[3]} ${currentRateVector[4]} ${currentRateVector[5]} ${currentRateVector[6]} $ru_rate ${switchesVector[1]} ${switchesVector[2]} ${switchesVector[3]} ${switchesVector[4]} ${switchesVector[5]} ${switchesVector[6]} $rep_list $rep_list $rep_list $rep_list $rep_list $rep_list 0.1 ${nLteRbgs[${rbIndex}]} $solution_output_file

                                if [ "$DEBUG" == true ]
                                then
                                    echo "leaving AVIS " `date '+%H_%M_%S.%3N'`
                                fi

                                # only update if the avis_output file exists
                                if [ -f $solution_output_file ] 
                                then
                                        
                                    # get the avis output
                                    avis_output=`cat $solution_output_file`

                                    # get the first value in the output list
                                    avis_output_first_val=`echo $avis_output | awk '{print $1}'`

                                    if [ "$DEBUG" == true ]
                                    then
                                        echo "avis_output_first_val" $avis_output_first_val
                                    fi

                                    # only update if the avis_output file provides rates
                                    if ! [ "$avis_output_first_val" == "-1" ]
                                    then
                                        total_rate=0
                                        parent_rate=0
                                        parent_ceil_rate=0
                                        for i in `eval echo {1..$num_clients}`
                                        do

                                            if [ "$DEBUG" == true ]
                                            then
                                                echo ""
                                                echo "client" $i "ip 12.0.0." ${RNTI[i]}
                                            fi

                                            # CODE HERE TO GET SEG # FROM CLIENTS
                                            client_file=./${run_output_folder}/client${RNTI[i]}/$output_GPAC_file
                                            if [ "${activityFlags[i]}" == "0" ] && [ "$(grep -c "Opening URL http" $client_file)" -ge 1 ] && [ "${activityStartBoolean[i]}" == "0" ]
                                            then
                                                # reset activity to 1
                                                if [ "$DEBUG" == true ]
                                                then
                                                    echo "Client has made a request: Set activity vector for client" $i "to 0"
                                                fi

                                                activityFlags[i]=1;
                                                bufferTimerVector[$i]=`date '+%s.%3N'`
                                                # so we only come in here once
                                                activityStartBoolean[i]=1;
                                            elif [ "${activityFlags[i]}" == "0" ] || [ "$(grep -c " segment $numSegment" $client_file)" -ge 2 ]
                                            then
                                                # a client has finished
                                                if ! [ "${activityFlags[i]}" == "0" ]
                                                then
                                                    if [ "$DEBUG" == true ]
                                                    then
                                                        echo "client" $i "has completed download, activity set to zero "
                                                    fi
                                                    activityFlags[i]=0;
                                                    ./tc/htb delete_child -ip ${RNTI[i]}; # delete child queue
                                                    finishedClients=$(($finishedClients+1));# increment our finished client counter
                                                    switchesVector[$i]=0;# set the switch vector to zero also, as we never get back into the code to reset to zero
                                                    
                                                    # if all clients have finished
                                                    if [ "${finishedClients}" == "$num_clients" ]
                                                    then
                                                        break 2
                                                    fi
                                                fi
                                            else
                                                max_rep_rate=`echo $rep_list | awk '{print $10}'`
                                                cur_rate_index=`echo $avis_output | awk -v a=$i 'BEGIN{ myIndex=a} {print $myIndex}'`; #returned by avis
                                                next_rate_index=$(($cur_rate_index+1 )); # increase the zero-based index to a one-based index
                                                prev_rate_value=${currentRateVector[i]}; # save the current allocated rate for this client                                                
                                                # next get the rep rate based on this index                                                 
                                                currentRateVector[i]=`echo $rep_list | awk -v a=$next_rate_index 'BEGIN{ next_rate=a}{print $next_rate}'`                                                
                                                parent_rate=$(($parent_rate+${currentRateVector[i]})); # update the parent code                                                
                                                # determine the total rate summed over all clients
                                                total_rate=$(( $total_rate + ${currentRateVector[i]} ));

                                                if [ "$DEBUG" == true ]
                                                then
                                                    echo "max_rep_rate" $max_rep_rate
                                                    echo "cur_rate_index" $cur_rate_index
                                                    echo "next index" $next_rate_index
                                                    echo "prev_rate_value" $prev_rate_value
                                                    echo "cur_rate" ${currentRateVector[i]}
                                                    echo "total_rate" $total_rate
                                                fi

                                                # client switches - no switch up
                                                if [ "${clientSwitch2DCounter[$i]}" == "$(( $switch_counter_value_AVIS_SAP - 1 ))" ] 
                                                then
                                                    clientSwitch2DCounter[$i]=0;
                                                    if [ "$DEBUG" == true ]
                                                    then
                                                        echo "reset switchVector"
                                                    fi

                                                else
                                                    # otherwise increment the 'j' counter
                                                    clientSwitch2DCounter[$i]=$(( ${clientSwitch2DCounter[$i]}+1 ));
                                                fi
                                                # if the client is at the same rate, there is no need to update TC
                                                if [ "${currentRateVector[i]}" == "$prev_rate_value" ]
                                                then
                                                    if [ "$DEBUG" == true ]
                                                    then
                                                        echo "client at same rate," $prev_rate_value "not updating TC"
                                                    fi
                                                    # we need to check if we are at the highest rate for the parent ceiling
                                                    if ! [ "${currentRateVector[i]}" == "$max_rep_rate" ]
                                                    then
                                                        
                                                        # if not at the max get the next rate up - zero index list
                                                        value=`get_rep_rate_index ${currentRateVector[i]} "${rep_list[@]}"`
                                                        next_rep_rate=`echo $rep_list | awk -v a=$value 'BEGIN{ val=a; val=val+2;}{print $val}'`
                                                        max_rate=$(( $((${currentRateVector[i]} + $next_rep_rate )) / 2))
                                                        
                                                    else                                                        
                                                        max_rate=$(echo "scale=0; ${currentRateVector[i]}*1.25/1" | bc)
                                                        if [ "$DEBUG" == true ]
                                                        then
                                                            echo "at max rate" ${currentRateVector[i]}
                                                        fi
                                                    fi
                                                    # mandate no change in the switch value
                                                    clientSwitch2DVector[$i,${clientSwitch2DCounter[$i]}]=0;
                                                    
                                                    parent_ceil_rate=$(($parent_ceil_rate+$max_rate)); # update the parent ceil rate
                                                        
                                                    # if we are now at the highest rate then save this
                                                elif [ "${currentRateVector[i]}" == "$max_rep_rate" ]
                                                then
                                                    max_rate=$(echo "scale=0; ${currentRateVector[i]}*1.25/1" | bc)
                                                    if [ "$DEBUG" == true ]
                                                    then
                                                        echo "at max rate" ${currentRateVector[i]}
                                                    fi                                                    
                                                    parent_ceil_rate=$(($parent_ceil_rate+$max_rate)); # update the parent ceil rate
                                                    ./tc/htb rules -ip ${RNTI[i]} -min ${currentRateVector[i]} -max $max_rate
                                                    # increase the switch value
                                                    clientSwitch2DVector[$i,${clientSwitch2DCounter[$i]}]=1;
                                                    # update the client TC
                                                else
                                                    # get the next rate up - zero index list
                                                    value=`get_rep_rate_index ${currentRateVector[i]} "${rep_list[@]}"`

                                                    # get the value of the next index up - assume zero-index input and 1-index output
                                                    next_rep_rate=`echo $rep_list | awk -v a=$value 'BEGIN{ val=a; val=val+2;}{print $val}'`                                            
                                                    # max_rate
                                                    max_rate=$(( $((${currentRateVector[i]} + $next_rep_rate )) / 2))
                                                    if [ "$DEBUG" == true ]
                                                    then
                                                        echo "index value" $value
                                                        echo "next rate up" $next_rep_rate
    		                                            echo "max_rate" $max_rate
                                                    fi

                                                    # update the parent ceil rate
                                                    parent_ceil_rate=$(($parent_ceil_rate+$max_rate))
                                                    
                                                    # update child queue
                                                    ./tc/htb rules -ip ${RNTI[i]} -min ${currentRateVector[i]} -max $max_rate
                                                    
                                                    
                                                    # increase the switch value
                                                    clientSwitch2DVector[$i,${clientSwitch2DCounter[$i]}]=1;
		                                            
                                                fi
                                                # we need to sum up the clientSwitches
                                                switchesVector[$i]=0;
                                                for j in `eval echo {0..$(( $switch_counter_value_AVIS_SAP - 1 ))}`
                                                do
                                                
                                                    # echo "switchesVector" ${switchesVector[$i]} " clientSwitch2DVector[$i,$j] i-" $i "j-" $j "value" ${clientSwitch2DVector[$i,$j]}
                                                    switchesVector[$i]=$(( ${switchesVector[$i]} + ${clientSwitch2DVector[$i,$j]} ));
                                                done

                                                if [ "$DEBUG" == true ]
                                                then
                                                    echo "switchesVector[$i] " ${switchesVector[$i]} "for client" $i
                                                    echo ""
                                                fi

                                            fi
		                                   
                                        done
	                                    # update the tc parent with a lower overall max_rate
                                        if [ "$DEBUG" == true ]
                                        then
                                            echo "parent_rate" $parent_rate
                                            echo "parent_ceil_rate" $parent_ceil_rate
                                        fi
	                                    
	                                    # only update if clients are streaming
	                                    # if [ $parent_rate -ge 100 ]
                                        if (( $(echo "${parent_rate}>=1" | bc -l) ))
                                        then
                                            ./tc/htb parent_rule -rate $parent_rate -max $parent_ceil_rate
                                        fi
	                                    
                                        if [ "$DEBUG" == true ]
                                        then
                                            ./tc/htb show
                                        fi
	                                
                                    fi

                                    if [ "$DEBUG" == true ]
                                    then
                                        echo ""
                                    fi

                                fi

                                if [ "$DEBUG" == true ]
                                then
                                    echo ""
                                    echo "End of AVIS TIME LOOP - " `date '+%s.%3N'` " End value - "$end
                                    echo ""
                                fi
	                            elapsedTime=`date '+%s.%3N'`
                            done
                            ############# Post processing starts here ###########

                            if [ "$DEBUG" == true ]
                            then
                                echo ""
                                echo "End of TOTAL TIME LOOP  - " `date '+%s.%3N'` " End value - "$end
                                echo ""
                            fi

                            # remove queues
                            if [ "$DEBUG" == true ]
                            then
                                ./tc/htb show
                            fi
		                    
                            ./tc/htb reset
		                    
                            if [ "$DEBUG" == true ]
                            then
                                ./tc/htb show
                            fi
		
                        fi
                            # if all clients have finished
                        if [ "${finishedClients}" == "$num_clients" ]
                        then
                    
                            # kill the ns3-lte network
                            if [ "$DEBUG" == true ]
                            then
                                echo "stop the ns3-lte network at " `date '+%s.%3N'`
                            fi

                            sudo -u user1 dsh -M -g ns3 "cd ~/Code/ns-3-allinone/ns-3-dev; echo 1 > ./lteStopFile.txt; killall -9 lena-simple-epc-tap-nas;"
                            sleep $[ $build_sleep ]
                        
                        else
		                    sleep $[ $build_sleep * 3 ]
                            if [ "$DEBUG" == true ]
                            then
                                echo "The ns3-lte network ran for the full duration and stopped at " `date '+%s.%3N'`
                            fi

                        fi
		                
		                
		                
                        # =============  RUN AT END TO CLEAN UP THE CLIENTS ==============
		                
                        # shut down eth2 so no traffic gets through
                        eth2State=`cat /sys/class/net/eth2/operstate`
                        if [ "$eth2State" == "up" ]
                        then

                            if [ "$DEBUG" == true ]
                            then
                                echo "eth2 was up, so bring it down"
                            fi
                            ifconfig eth2 down
                        fi

                        if [ "$DEBUG" == true ]
                        then
                            echo "run the collection scripts"
                        fi

                        sudo -u user1 dsh -M -g ns3 "cd ~/Code/ns-3-allinone/ns-3-dev; ./waf --run \"scratch/lena-simple-epc-tap-nas --numberOfNodes=$num_clients --simTime=${collectionDuration} --distance1=0.0 --distance2=0.0 --distance3=0.0 --distance4=0.0 --distance5=0.0 --distance6=0.0\""  > $trace_output_folder/master_file-collection.txt &

                        sudo -u user1 sleep $build_sleep
                        
                        # clean up the client screens, and create the columnised trace files
                        sudo -u user1 ./GPAC/kill_GPAC.sh &
		                
                        # to make sure the columnised trace files have been created
                        sleep $[ $build_sleep * 2 ]
                        
                        # reset terminal for next set of experiments
                        killall -9 gnome-terminal
		                
                        # bring up eth2 incase it was down
                        eth2State=`cat /sys/class/net/eth2/operstate`
                        if [ "$eth2State" == "down" ]; then
                            if [ "$DEBUG" == true ]; then
                                echo "eth2 was down, so bring it up"
                            fi
                            ifconfig eth2 up
                        fi

                        # =============  RUN AT END TO COLLECT THE GENERATED TRACE FILES ==============

                        # NOT sure why I have if and else here, must check this
                        
                        # NOT sure why I have if and else here, must check this
                        local_trace_output_folder="trace_input"

                     
                        # copy the columned file from the clients to the local machine
                        sudo -u user1 ./file_copying/copy_files_from_clients.sh ${runNum} ${algo} ${model} ${TCValue} ${LTEscheduler} ${segDurations[$numSegCounter]}  ${local_trace_output_folder} ${lte_clients} &

                        # sleep a little bit more
                        sudo -u user1 sleep $[ $collectionDuration - $(( $build_sleep * 2 )) ]
                            
                        for i in `eval echo {1..$num_clients}`
                        do
                        # we need the client number as this will the client trace number
                           
                           # the url index needs to consider the url selected and the seg duration index
                           client_index_less_one=$((i-1))
                           
                           # echo $client_index_less_one
                           
                           # url index to use for this user - we need the '!' to provide bash indirect expansion
                           url_index="clip_array_run_${runNum}[$client_index_less_one]"
                           
                           # echo $url_index "url_index"
                           
                           vId=$(echo ${!url_index})
                            output_folder=${run_output_folder}/client${DEVICE[${i}]}
                            
                            outputFolder=${local_trace_output_folder}/$algo/${segDuration}_second/${LTEscheduler}_${model}/${TCValue}/R_${runNum}/client${DEVICE[${i}]}
                            
                            cp $outputFolder/${file_format}${i}.txt $output_folder/${file_format}-V$vId-R${runNum}-C${i}.txt	                        
                        done

                        if [ "$DEBUG" == true ]
                        then
                            echo ""
                            echo ""
                            echo ""
                        fi
	                  done #URL (session)

                if [ "$DEBUG" == true ]
                then
                    echo ""
                fi

	             done #segment size

            if [ "$DEBUG" == true ]
            then
                echo ""
            fi

	         done #scheduler
	         
	        # if not SAP, then break 'stall_Weight' loop
	        if ! [[ $TCValue =~ .*SAP.* ]]
	        then
	        
	            break;
	        
	        fi

        if [ "$DEBUG" == true ]
        then
            echo ""
        fi

	     done # stall weight

    if [ "$DEBUG" == true ]
    then
        echo ""
    fi

	 done  # traffic control

    if [ "$DEBUG" == true ]
    then
        echo ""
    fi

  done # algo

if [ "$DEBUG" == true ]
then
    echo ""
fi

done #model




