#!/bin/bash

# in this script we copy remote files to a local store location

# =============  USER CONFIG SOURCE FILES ==============
source config_files/user_input.conf

urlNum=$1;
algo=$2; 
model=$3;
TCValue=$4;
LTEscheduler=$5;
segDuration=$6;
local_trace_output_folder=$7;
nClients=$8;

# =============  DEFINE SOME VARIABLES ==============
# store the start time
dt=`date '+%d_%m_%Y_%H_%M_%S'`
# output folder where we save the trace files
# outputFolder="../trace_input/$algo/${dt}_${model}_${urlNum}"
# outputFolder="../${local_trace_output_folder}/${algo}/${segDuration}_second/${LTEscheduler}_${model}/${TCValue}/R_${urlNum}"

# new folder structure to save all files in one location
outputFolder="${local_trace_output_folder}/$algo/${segDuration}_second/${LTEscheduler}_${model}/${TCValue}/R_${urlNum}"


# =============  COPY THE FILES ==============
echo "Copy Files From Clients"
for cIndex in `seq 1 $nClients`; 
do 
   printf "Client" $cIndex "\n"; 
   
   # the url index needs to consider the url selected and the seg duration index
   client_index_less_one=$((cIndex-1))
   
   # echo $client_index_less_one
   
   # url index to use for this user - we need the '!' to provide bash indirect expansion
   url_index="clip_array_run_${urlNum}[$client_index_less_one]"
   
   # echo $url_index "url_index"
   
   url_to_use=$(echo ${!url_index})
   
   # echo $url_to_use " is the clip index to use for "${clip_array_name[url_to_use]}
   
   
   # =============  CREATE THE FOLDER STRUCTURE ==============
   # create the trace file folder location
   #mkdir -p $outputFolder/${clip_array_name[url_to_use]}
   mkdir -p $outputFolder/client${DEVICE[${cIndex}]}
   ( scp user1@"12.0.0."${DEVICE[${cIndex}]}:~/Desktop/${file_format}${cIndex}.txt ${outputFolder}/client${DEVICE[${cIndex}]}/${file_format}${cIndex}.txt && ssh "12.0.0."${DEVICE[${cIndex}]} "rm ~/Desktop/${file_format}${cIndex}.txt" ) &

done
