# This file is MP4Client_column_output.awk
# jason quinlan - j.quinlan@cs.ucc.ie - 05th August 2015 - v0.2.1

# execute using 'awk -v a="clientID" -v b="clip Folder Input" -v c="number of Segments" -v clip="clip name" -v bitRateList="representation rates" -v printOut="boolean to print out lines from gpac trace file" -f MP4Client_column_output.awk mpdFile > columnisedOutputFile.txt'

# example
# awk -v a="1" -v b="output" -v c="75" -v clip="clip name" -v bitRateList="4300 3000 2500" -v printOut="true" -f MP4Client_column_output.awk mpdFile > columnisedOutputFile.txt

	# return a specific part of the input string
	function seperateList( stringLine, my_array, stringBreak, returnIndex){

		# printf("stringLine %s stringBreak %s\n", stringLine, stringBreak);
	
		split(stringLine, my_array, stringBreak);
	
		return my_array[returnIndex]
	}


BEGIN {

	# FS means field seperator, and denotes that charcter that seperates the columns.
	# this script will separate based on a space.
	FS = " "

# Initialization.

	# number of segments to use in the start up phase - 1 by default - 
        # based on 'PlayoutLength=12000' in our 'adaptiveGPACrc' file under '[MISL-EXTRA]'
	numSegmentStartUpPhase=2;

	# define a few variables
	clientID 			= a; # passed in value
	folderStruct 		= b; # passed in value
	myNumSegments		= c; # passed in value - no header
	clipName			= clip; # passed in value
	printLines			= printOut; # passed in value
	
	# create an array
	for(k = 0 ; k < myNumSegments; k++) {
		bufferTime[k] = 0;
	}
	
	# variables
	firstBufferTime = 0;
	firstSegmentReceived = 0;
	baseBufferLevel = 3;
	firstDeliveryRate = 0;
	
	# get the individual rates from the input bitrate list
	split(bitRateList, rateArray, " ");

	# save these values to local array
	y=0;
	for (i in rateArray) {
		repValues[i]=rateArray[i]/1000;
	}
	
	# counters
	counter = 0;
	
	# variables
	timeString = "Date: ";
	httpString = "[HTTP]";
	ftpString  = "fps_";
	mpdString  = "[MPD_IN]";
	isoString  = "[IsoMedia]";
	dashString = "[DASH]";
	
	# output file for getting the lines we want from the log file 
	logFileOutput = folderStruct "MP4Client_log_trace" a "_" clipName ".txt";

}

{

	# DONE - THIS CODE sets the first segment call through
	if($1 == httpString){
		if($2 == "Sending"){
			
			if($5 ~ ftpString && $5 !~ "segmentinit"){
			
				# print this input line to an output file
				if( printLines == "true" ){
					print($0) > logFileOutput;
				}
				
				firstSegmentReceived = 1;
			}
		}
	}
	
	
	# DONE - THIS CODE GETS the segment byte cost and relavent delivery rate
	if($1 == dashString){
		if(($2 == "Downloaded" || $2 == "Download") && $3 != "rate" ){
		
			# print this input line to an output file
			if( printLines == "true" ){
				print($0) > logFileOutput;
			}
			
			# get the start time of the initialisation
			if(firstDeliveryRate == 0){
			
				firstDeliveryRate = 1;
				
				# split the string around the " UTC "
				timeDeliveryList = seperateList($0, my_array, " UTC ", 2);
				
				# split the string around the " UTC "
				timeMsSpacing[0] = seperateList(timeDeliveryList, my_array, " ms", 1);
				
				# start time
				firstDownloadSegmentTime = timeMsSpacing[0];
				
				# print("time spacing[0]" timeMsSpacing[0]);
			
			}
			else {
			
				# split the string around the ".m4s " - return first array
				dashSegmentList = seperateList($0, my_array, ".m4s ", 1);
			
				# split the string around the "segment"
				
				tempStoreValue = seperateList(dashSegmentList, my_array, "_segment", 2)
				if(tempStoreValue !~ "init.mp4"){
				
					deliverySegment = seperateList(dashSegmentList, my_array, "_segment", 2);
					jumpOver = 0;
					
					# print(deliverySegment);
				}
				else{
					
					jumpOver = 1;
				}
			
				# split the string around the ".m4s " - return second array
				dashList = seperateList($0, my_array, ".m4s ", 2);
			
				if(jumpOver != 1){
					if($2 == "Downloaded"){
			
						# print($0);

						# get the byte size of this segment
						globalFileOutput[deliverySegment, 4] = seperateList(dashList, my_array, " ", 1);
						segmentByteSize[deliverySegment]	 = globalFileOutput[deliverySegment, 4];
						
						# get the delivery time for this segment
						globalFileOutput[deliverySegment, 5] = seperateList(dashList, my_array, " ", 4);
						segmentDeliveryTime[deliverySegment] = globalFileOutput[deliverySegment, 5];
						
						# get the delivery rate for this segment
						segmentByteDeliveryRate[deliverySegment] = ((segmentByteSize[deliverySegment]/segmentDeliveryTime[deliverySegment])*8)/1000000;
						
						# get the playback duration for this segment
						globalFileOutput[deliverySegment, 6] = seperateList(dashList, my_array, " ", 8);
						segmentDuration[deliverySegment]	 = globalFileOutput[deliverySegment, 6];
						
						# get the representation rate for this segment
						representArray[deliverySegment] 	 = seperateList(dashList, my_array, " ", 14);
						
					}
					else{
			
						# print($0);
						
						# get the arrival time for this segment
						timeMsSpacing[deliverySegment] =  seperateList(dashList, my_array, " ", 4);
						
						# print(timeMsSpacing[deliverySegment]);
			
					}
				}
			}
		}
	}

	# DONE - lets get the time that the segments are loaded into the buffer and 
	# into the player.
	if($1 == mpdString){
		if($2 == "Next"){
			
			if($5 ~ ftpString && $5 !~ "segmentinit"){
			
				# print this input line to an output file
				if( printLines == "true" ){
					print($0) > logFileOutput;
				}
				
				# split the string around the ftpString
				kbpsList = seperateList($0, my_array, ftpString, 2);
				
				# split the string around the "segment"
				segmentList = seperateList(kbpsList, my_array, "segment", 2);
				
				# split the string around the ".m4s", first array, and get the segment number
				segmentLoad = seperateList(segmentList, my_array, ".m4s", 1);
				
				# split the string around the ".m4s", second array
				timeList = seperateList(segmentList, my_array, ".m4s", 2);
				
				# split the string around the " at ", second array
				loadTime = seperateList(segmentList, my_array, " at ", 2);

				# lets just get the load time to the player
				if(segmentLoad == 1){
					playerLoadTime[segmentLoad] = 0;
				}
				else {
					playerLoadTime[segmentLoad] = (loadTime/1000);
					
					# previously I had added 1 to the loadTime, lets remove this
					# playerLoadTime[segmentLoad] = (loadTime/1000)+1;
				}
			}	
		}
	}
	
	
	# lets get the buffer levels
	# we have two different buffer levels, under and above max threshold, so we need to 
	# work through both
	if($1 == isoString){
	
		if($2 ~ "Buffer"){
		
			# print this input line to an output file
			if( printLines == "true" ){
				print($0) > logFileOutput;
			}
		
			if($4 == "is"){
			
				# split the string around the ftpString
				bufferList = seperateList($0, my_array, "is ", 2);
				
				# split the string around the "segment"
				bufferSize = seperateList(bufferList, my_array, " ms", 1)/1000;
				
				dashBufferTime = seperateList($0, my_array, " at ", 2);
				
				# print("under max " dashBufferTime);
				# print(segmentLoad);
			
				bufferLevels[int(dashBufferTime/1000)] = bufferSize;
	
			}
			else {
			
				# split the string around the ftpString
				bufferList = seperateList($0, my_array, "level ", 2);
				
				# split the string around the "segment"
				bufferSize = seperateList(bufferList, my_array, " ms higher", 1)/1000;
				
				dashBufferTime = seperateList($0, my_array, " at ", 2);
				
				# print("over max " dashBufferTime);
				# print(segmentLoad);
				# print(bufferSize+baseBufferLevel);
			
				bufferLevels[int(dashBufferTime/1000)] = bufferSize;
			}
			
			# printf("bufferLevels[int(dashBufferTime/1000)] %f  segment %d diffTime %d\n", bufferLevels[int(dashBufferTime/1000)] , segmentLoad, int(dashBufferTime/1000));
			
			# save the max time, so we can use it later for print out
			maxTime = int(dashBufferTime/1000)
		}
	}
}	


END {

	for(val in repValues){
		repCountHistogram[repValues[val]] = 0;
		repDifference[repValues[val]] = 0;
	}

	segmentByteSizeTotal = 0;
	segmentDeliveryTimeTotal = 0;
	maxRepresentationChange = 0;
	# this prints out the representations to an output file
	# also prints out the load time to player
	# also prints out the load time to the buffer
	for(k = 1 ; k <= myNumSegments; k++) {
		
		# lets save values for later
		globalFileOutput[k, 3] = representArray[k]/1000;
		
		repCountHistogram[representArray[k]/1000] += 1;
		
		if(k==0) {
			
			# save for later
			globalFileOutput[k, 7] = 0;
		}
		else {
		
			repDifferenceValue = (representArray[k]/1000) - (representArray[k-1]/1000);
	
			if(repDifferenceValue < 0){
				repDifferenceValue = (representArray[k-1]/1000 - (representArray[k]/1000));
				
				if((representArray[k-1]/1000) >= 3){
				
					if((representArray[k]/1000) >= 3){
					
						repNumDifferenceValue = repDifferenceValue
					}
					else {
						diff = (representArray[k-1]/1000) - 3;
						segDiff = (repDifferenceValue - diff)*2;
			
						repNumDifferenceValue = (diff)+(segDiff)
					}
				}
				else {
					repNumDifferenceValue = repDifferenceValue*2;
				}
			}
			else if(repDifferenceValue != 0){
			
				if((representArray[k]/1000) >= 3){
				
					if((representArray[k-1]/1000) >= 3){
					
						repNumDifferenceValue = repDifferenceValue
					}
					else {
						diff = (representArray[k]/1000) - 3;
						segDiff = (repDifferenceValue - diff)*2;
			
						repNumDifferenceValue = (diff)+(segDiff)
					}
				}
				else {
					repNumDifferenceValue = repDifferenceValue*2;
				}
			}
			else{
				repNumDifferenceValue = 0;
			}
			
			if(maxRepresentationChange < repNumDifferenceValue){
				maxRepresentationChange = repNumDifferenceValue;
			}
			
			# this gives us the changes in bitrates
			# repDifference[repDifferenceValue] +=1;
			
			# this gives us the changes in number of representation levels
			repDifference[repNumDifferenceValue] +=1;
			
			# save for later
			globalFileOutput[k, 7] = repNumDifferenceValue;
		}
		
		segmentByteSizeTotal += segmentByteSize[k];
		segmentDeliveryTimeTotal += segmentDeliveryTime[k];
		segmentByteDeliveryRateTotal += segmentByteDeliveryRate[k];
	}
		
	# work out the stalls
	numStalls = 0;
	numStallDuration = 0;
	segmentLate = 0;
	for(k = 1 ; k <= myNumSegments; k++) {
		
		# if we set this to timeMsSpacing[0], first seg arrival time is the time it arrived
		initial_deliveryRate=((timeMsSpacing[numSegmentStartUpPhase] - timeMsSpacing[0])/1000);
		
		preSegArrivalTime = (timeMsSpacing[k-1] - timeMsSpacing[0])/1000;
		segArrivalTime = (timeMsSpacing[k] - timeMsSpacing[0])/1000;
		
		# 29-04-2016: if I use k, I end up with a seg too much in my calculations
		segPlayOutTime = (k-1)*segmentDuration[k]+numStallDuration+initial_deliveryRate;
		
		# print(k);
		# print(segmentDuration[k]);
		# print(initial_deliveryRate);
		# print(preSegArrivalTime);
		# print(segArrivalTime);
		# print(segPlayOutTime);
		# print("");
		
		segStallDuration = 0;
		# CHANGING 'k > 1' to 'k > numSegmentStartUpPhase' needs to be checked :)
		if((segArrivalTime > segPlayOutTime)  && k > numSegmentStartUpPhase){
		
			segStallDuration = (segArrivalTime - segPlayOutTime);
			
			# print("stalls");
			# print(segArrivalTime);
			# print(segPlayOutTime);
		 	# print(segStallDuration);
			# print("");
			
			segPlayOutTime += segStallDuration;
			numStallDuration += segStallDuration
			
			numStalls++;
		}

		# get the buffer level : value of previous buffer less difference between current seg arrival time and previous
		# seg arrival time, plus seg duration plus current seg stall duration
		# if we include for some start up phase segment the value is used here, and current is set to zero
		if(k < (numSegmentStartUpPhase+1)){
			currentLevel = 0;
		}
		else{
			currentLevel = (segArrivalTime - ((timeMsSpacing[k-1] - timeMsSpacing[0])/1000));
		}
		globalFileOutput[k, 8] = (((globalFileOutput[k-1, 8] - currentLevel) + segmentDuration[k]))+segStallDuration;
		
		# print("buffer");
		# print(globalFileOutput[k, 8]);
		# print(globalFileOutput[k-1, 8]);
		# print(currentLevel);
		# print(segmentDuration[k]);
		# print(segStallDuration);
		# print(segPlayOutTime);
		# print("");
		
		# lets save values for later
 		globalFileOutput[k, 1] = segArrivalTime;
 		globalFileOutput[k, 2] = segStallDuration;
	}


	
	# lets print one global file that contains everything :)
	
	# original columns headers
	
	# new columns headers required by Ahmed
	printf("Seg_#  Arr_time  Del_Time  Stall_Dur  Rep_Level  Del_Rate  Act_Rate  Byte_Size  Buff_Level\n");

	for(k = 1 ; k <= myNumSegments; k++) {
	
		# we need to make sure the buffer is always zero or greater, sometimes we get negative zero, so this rounds up
		bufferLevel = globalFileOutput[k, 8];
		if(bufferLevel < 0){
			bufferLevel=0;
		}
		
		# new columns required by Ahmed
		# old - printf("%5d %9d %9d %10d %10d %9d %9d %10d %11.3f\n", k, globalFileOutput[k, 1]*1000, globalFileOutput[k, 5]*1000, globalFileOutput[k, 2]*1000, globalFileOutput[k, 3]*1000, segmentByteDeliveryRate[k]*1000, (globalFileOutput[k, 4]/(globalFileOutput[k, 5]*1000)), globalFileOutput[k, 4], bufferLevel);
		
		if( (globalFileOutput[k, 3]*1000) > 1 ){
		
		    # new
		    printf("%5d %9d %9d %10d %10d %9d %9d %10d %11.3f\n", k, globalFileOutput[k, 1]*1000, globalFileOutput[k, 5]*1000, globalFileOutput[k, 2]*1000, globalFileOutput[k, 3]*1000, segmentByteDeliveryRate[k]*1000, ((globalFileOutput[k, 4]*8)/segmentDuration[k])/1000, globalFileOutput[k, 4], bufferLevel);
		
		    # Act_Rate (globalFileOutput[k, 4]/(globalFileOutput[k, 5]*1000))*8 = gives the same value as Del_Rate 
		}
	}
}
