package edu.ucc.testbedinterface;

import edu.ucc.core.ContentTransmitter;
import edu.ucc.core.HandoverManager;
import edu.ucc.core.PrefetchManager;
import edu.ucc.core.events.simulationevents.HandoverEvent;
import edu.ucc.core.events.simulationevents.PullRequestEvent;
import edu.ucc.core.transport.chunks.ContentChunk;
import edu.ucc.network.devices.EdgeServer;
import edu.ucc.network.devices.Host;

import java.util.List;

/**
 * This interface contains all the events that our solution could be notified from the testbed through the broker. This
 * is Pub-Sub pattern https://hackernoon.com/observer-vs-pub-sub-pattern-50d3b27f838c rather than observer.
 */
public interface ITestbedEvents extends HandoverManager, ContentTransmitter, PrefetchManager {
    void onChunkTransmittedUpwards(Host host, ContentChunk chunk);

    void onChunkTransmittedDownwards(Host host, ContentChunk chunk, double currentTime);

    void onChunkTransmittedToSibling(Host host, ContentChunk chunk);

    void onPullRequestServedLocally(EdgeServer edgeServer, PullRequestEvent pullRequestEvent);

    boolean isAppDeployedHere(Host host, int appId);

    Host findDestinationForChunkAtServerWithoutApp(ContentChunk chunk, EdgeServer edgeServer, int appId);

    void registerInitialMobilityEvent(List<HandoverEvent> initialMobilityEvents);
}
