package edu.ucc.statisticscollection;

import edu.ucc.entities.Content;
import edu.ucc.network.devices.Host;

public class PushRequest extends Request {
    private final Host pushInitiatorHost;
    private final Host pushDestinationHost;

    public PushRequest(int requestId, Host currentHost, Content referredContent, double requestTimestamp,
                       long totalChunks, Host pushInitiatorHost, Host pushDestinationHost) {
        super(requestId, currentHost, referredContent, requestTimestamp, totalChunks);
        this.pushInitiatorHost = pushInitiatorHost;
        this.pushDestinationHost = pushDestinationHost;
    }

    public Host getPushInitiatorHost() {
        return pushInitiatorHost;
    }

    public Host getPushDestinationHost() {
        return pushDestinationHost;
    }
}
