package edu.ucc.statisticscollection;

import edu.ucc.entities.Content;
import edu.ucc.network.devices.Host;


public abstract class PullRequest extends Request {
    private final Host requestingHost;
    private final Host contentLocationHost;

    public PullRequest(int requestId, Host currentHost,  Content referredContent, double requestTimestamp,
                       Host requestingHost, Host contentLocationHost, int totalChunks) {
        super(requestId, currentHost, referredContent, requestTimestamp, totalChunks);
        this.requestingHost = requestingHost;
        this.contentLocationHost = contentLocationHost;
    }


    public Host getRequestingHost() {
        return requestingHost;
    }

    public Host getContentLocationHost() {
        return contentLocationHost;
    }

    public long getTransmittedChunksUpwards() {
        return transmittedChunksUpwards;
    }

    public long getTransmittedChunksDownwards() {
        return transmittedChunksDownwards;
    }
}


