package edu.ucc.network.devices;

public enum StorageReason {
    /**
     * When popularity has been detected locally.
     */
    LOCAL_POPULARITY{
        @Override
        public String toString() {
            return "Popularity (local)";
        }
    },
    /**
     * Content is received as popularity was detected in a sibling host.
     */
    EXTERNAL_POPULARITY{
        @Override
        public String toString() {
            return "Popularity (external)";
        }
    },
    /**
     * An app explicitly requested pushing content from the cloud.
     */
    DIRECT_APP_PUSH_REQUEST {
        @Override
        public String toString() {
            return "Direct app push request";
        }
    },
    /**
     * Content
     */
    OPPORTUNISTIC {
        @Override
        public String toString() {
            return "Opportunistic";
        }
    },

    /**
     * Data for pending events
     */
    PENDING_EVENT_PROCESSING{
        @Override
        public String toString() {
            return "Pending event processing";
        }
    }
}
