package edu.ucc.network.devices;

import edu.ucc.core.transport.routing.RoutingTable;
import edu.ucc.testbedinterface.ITestbedEvents;

import java.io.Serializable;
import java.util.List;

public class NetworkArchitecture implements Serializable {
    private final CloudUnit cloudRoot;
    private List<UserEquipment> userEquipments;
    private List<BaseStation> baseStations;
    private List<EdgeServer> edgeServers;
    private RoutingTable routingTable;
    private ITestbedEvents iEventsBroker;

    public NetworkArchitecture(CloudUnit cloudRoot) {
        this.cloudRoot = cloudRoot;
    }

    public ITestbedEvents getiEventsBroker() {
        return iEventsBroker;
    }

    public void setiEventsBroker(ITestbedEvents iEventsBroker) {
        this.iEventsBroker = iEventsBroker;
    }

    public CloudUnit getCloudRoot() {
        return cloudRoot;
    }

    /***
     *
     * Obtains the list of all of the User Equipments in the edu.ucc.network architecture
     * @return A List of {@link UserEquipment}
     */
    public List<UserEquipment> getUserEquipments() {

        return userEquipments;
    }

    public List<BaseStation> getBaseStations() {
        return baseStations;
    }

    @Override
    public String toString() {
        List<? extends Host> edgeServers = cloudRoot.getChildrenUnits();
        int numEdgeServers = edgeServers.size();
        int numBaseStations = 0;
        int numDevices = 0;
        for (Host edgeHost : edgeServers) {
            EdgeServer edgeServer = (EdgeServer) edgeHost;
            List<? extends Host> baseStations = edgeServer.getChildrenUnits();
            numBaseStations += baseStations.size();
            for (Host bsHost : baseStations) {
                BaseStation baseStation = (BaseStation) bsHost;
                numDevices += baseStation.getChildrenUnits().size();
            }

        }
        return String.format("This architecture has (1 cloud), %s Edge Servers, %s Base Stations and %s devices",
                numEdgeServers, numBaseStations, numDevices);
    }

    public void setUserEquipments(List<UserEquipment> unassignedUEs) {
        this.userEquipments = unassignedUEs;
    }

    public void setBaseStations(List<BaseStation> baseStations) {
        this.baseStations = baseStations;
    }

    public void setEdgeServers(List<EdgeServer> edgeServers) {
        this.edgeServers = edgeServers;
    }

    public List<EdgeServer> getEdgeServers() {
        return edgeServers;
    }

    public void setRoutingTable(RoutingTable routingTable) {
        this.routingTable = routingTable;
    }

    public RoutingTable getRoutingTable() {
        return routingTable;
    }
}

