package edu.ucc.network.architecture;

public class ArchitectureParameters {
    private final double bsRange;
    private final double mapWidth;
    private final double mapHeight;
    private final double totalUplinkForCloudChildren;
    private final double totalDownlinkForCloudChildren;
    private final double totalUplinkForEsChildren;
    private final double totalDownlinkForEsChildren;
    private final double totalBwForEsSiblings;
    private final double totalUplinkBwForBsChildren;
    private final double totalDownlinkBwForBsChildren;
    private int numEdgeServers;
    private int numUserEquipments;
    private final long storagePerEdgeServer;
    private final int mtu;

    public ArchitectureParameters(double bsRange, double mapWidth, double mapHeight,
                                  double totalUplinkForCloudChildren, double totalDownlinkForCloudChildren,
                                  double totalUplinkForEsChildren, double totalDownlinkForEsChildren,
                                  double totalBwForEsSiblings,
                                  double totalUplinkBwForBsChildren, double totalDownlinkBwForBsChildren,
                                  int numEdgeServers, long storagePerEdgeServer, int numUserEquipments, int mtu) {
        this.bsRange = bsRange;
        this.mapWidth = mapWidth;
        this.mapHeight = mapHeight;
        this.totalUplinkForCloudChildren = totalUplinkForCloudChildren;
        this.totalDownlinkForCloudChildren = totalDownlinkForCloudChildren;
        this.totalUplinkForEsChildren = totalUplinkForEsChildren;
        this.totalDownlinkForEsChildren = totalDownlinkForEsChildren;
        this.totalBwForEsSiblings = totalBwForEsSiblings;
        this.totalUplinkBwForBsChildren = totalUplinkBwForBsChildren;
        this.totalDownlinkBwForBsChildren = totalDownlinkBwForBsChildren;
        this.numEdgeServers = numEdgeServers;
        this.storagePerEdgeServer = storagePerEdgeServer;
        this.numUserEquipments = numUserEquipments;
        this.mtu = mtu;
    }

    public double getBsRange() {
        return bsRange;
    }

    public double getMapWidth() {
        return mapWidth;
    }

    public double getMapHeight() {
        return mapHeight;
    }

    public double getTotalUplinkForCloudChildren() {
        return totalUplinkForCloudChildren;
    }

    public double getTotalDownlinkForCloudChildren() {
        return totalDownlinkForCloudChildren;
    }

    public double getTotalUplinkForEsChildren() {
        return totalUplinkForEsChildren;
    }

    public double getTotalDownlinkForEsChildren() {
        return totalDownlinkForEsChildren;
    }

    public double getTotalBwForEsSiblings() {
        return totalBwForEsSiblings;
    }

    public double getTotalUplinkBwForBsChildren() {
        return totalUplinkBwForBsChildren;
    }

    public double getTotalDownlinkBwForBsChildren() {
        return totalDownlinkBwForBsChildren;
    }

    public int getNumEdgeServers() {
        return numEdgeServers;
    }

    public void setNumEdgeServers(int numEdgeServers) {
        this.numEdgeServers = numEdgeServers;
    }

    public long getStoragePerEdgeServer() {
        return storagePerEdgeServer;
    }

    public int getNumUserEquipments() {
        return numUserEquipments;
    }

    public void setNumUserEquipments(int numUserEquipments) {
        this.numUserEquipments = numUserEquipments;
    }

    public int getMtu() {
        return mtu;
    }
}

