package edu.ucc.graphic;

import edu.ucc.network.architecture.ArchitectureParameters;
import edu.ucc.network.devices.NetworkArchitecture;

import javax.swing.*;
import java.awt.*;

import static javax.swing.WindowConstants.EXIT_ON_CLOSE;

public class ScenarioVisualization {
    private VisualizationPanel thePanel;

    public ScenarioVisualization(String title, NetworkArchitecture networkArchitecture,
                                 ArchitectureParameters architectureParameters) throws HeadlessException {

        int width = 800; //(int) architectureParameters.getMapWidth();
        int height = 800; //(int) architectureParameters.getMapHeight();

        JFrame jframe = new JFrame(title);
        jframe.setSize(width + 10, height + 10);
        jframe.setDefaultCloseOperation(EXIT_ON_CLOSE);
        jframe.setResizable(false);

        thePanel = new VisualizationPanel(networkArchitecture, architectureParameters);
        jframe.setVisible(true);
        jframe.add(thePanel);
//        pack();
    }


    public void drawArchitecture() {
        thePanel.drawBaseStations();
        thePanel.drawUserEquipments();
        thePanel.drawEdgeServers();
    }
}
