package edu.ucc.entities;

import edu.ucc.network.devices.BaseStation;
import edu.ucc.network.devices.EdgeServer;
import edu.ucc.network.devices.UserEquipment;

/**
 * Base class to be extended by sample IoT applications to define new IoT data types.
 */
public class IoTData extends Data {
    private final UserEquipment dataSourceUE;
    private final IoTDataType dataType; // just for labeling purposes

    public IoTData(long size, UserEquipment dataSourceUE, IoTDataType dataType, double timestamp) {
        super(size, timestamp, true);
        this.dataSourceUE = dataSourceUE;
        this.dataType = dataType;
        this.updateURI();
    }

    public UserEquipment getDataSourceUE() {
        return dataSourceUE;
    }

    @Override
    public String getDescription() {
        //        return String.format("%s data from UE %s @ %s", dataType.toString(), sourceUE.getId(), timestamp);
        return String.format("%s data", dataType.toString());
    }

    public void updateURI() {
        BaseStation baseStation = (BaseStation) dataSourceUE.getParentUnit();
        EdgeServer edgeServer = (EdgeServer) baseStation.getParentUnit();
        //        String URI = String.format("Cloud/ES%s/BS%s/UE%s/%s/%s",
        //                edgeServer.getId(), baseStation.getId(), dataSourceUE.getId(), dataType.toString(), getTimestamp());
        String URI = String.format("Cloud/ES%s/BS%s/UE%s/%s",
                edgeServer.getId(), baseStation.getId(), dataSourceUE.getId(), dataType.toString());
        this.setURI(URI);
    }

    @Override
    public String toString() {
        return String.format("%s produced by UE %s, %s bytes", dataType.toString(), dataSourceUE.getId(), getSize());
    }

    public IoTDataType getDataType() {
        return dataType;
    }
}
