package edu.ucc.core.transport.routing;

import edu.ucc.core.events.simulationevents.HandoverEvent;
import edu.ucc.network.devices.BaseStation;
import edu.ucc.network.devices.EdgeServer;
import edu.ucc.network.devices.UserEquipment;

import java.util.HashMap;
import java.util.Map;

/***
 * This class models the sequence of steps to arrive from the cloud to a specific UE.
 * It should be updated after each {@link HandoverEvent}.
 * For simplicity a single object for this can be accessed from the edu.ucc.network architecture object
 */
public class RoutingTable {
    Map<UserEquipment, RoutingEntry> routingTable;

    public RoutingTable() {
        this.routingTable = new HashMap<>();
    }

    public void addEntryForUE(UserEquipment userEquipment, RoutingEntry routingEntry) {
        this.routingTable.put(userEquipment, routingEntry);
    }

    public RoutingEntry getEntryForUe(UserEquipment userEquipment) {
        return this.routingTable.get(userEquipment);
    }

    public void updateBsPartForUserEquipment(UserEquipment userEquipment, BaseStation targetBS) {
        final RoutingEntry entryForUe = getEntryForUe(userEquipment);
        entryForUe.updateBaseStationPart(targetBS);
    }

    public void updateEdgePartForUserEquipment(UserEquipment userEquipment, EdgeServer targetES) {
        final RoutingEntry entryForUe = getEntryForUe(userEquipment);
        entryForUe.updateEdgeServerPart(targetES);
    }
}
