package edu.ucc.core.transport.links;

import java.io.Serializable;

import static edu.ucc.utils.Logging.printWarning;

public class Link implements Serializable {
    protected double totalBandwidth;
    protected double availableBandwidth;

    public void reduceAvailableBandwidth(double amount) {
        double newBandwidth = this.availableBandwidth - amount;
        if (newBandwidth < 0) {
            // throw new IllegalArgumentException(String.format("The link can't support such decrease %s", newBandwidth));
            printWarning(String.format("Such decrease is not possible %s, assigning 0 instead. (Maybe a newly arrived" +
                    "UE is forcing this). Expect capping messages after receiving more chunks from BS", newBandwidth));
            newBandwidth = 0;
        }
        this.availableBandwidth = newBandwidth;
    }

    public void increaseAvailableBandwidth(double amount) {
        double newBandwidth = this.availableBandwidth + amount;
        if (newBandwidth > this.totalBandwidth) {
            printWarning(String.format("Capping the increase to link.totalBandwidth %s. This must happen only in a BS!", this.totalBandwidth));
//            throw new IllegalArgumentException(String.format("The link can't support such increase (%s>%s)", newBandwidth, totalBandwidth));
            newBandwidth = this.totalBandwidth;
        }
        this.availableBandwidth = newBandwidth;
    }

    public double getTotalBandwidth() {
        return totalBandwidth;
    }

    public double getAvailableBandwidth() {
        return availableBandwidth;
    }

    public void increaseTotalBandwidth(double increase) {
        this.totalBandwidth += increase;
    }

    public void reduceTotalBandwidth(double decrease) {
        double newTotalBandwidth = this.totalBandwidth - decrease;
        if (newTotalBandwidth < 0) {
            throw new IllegalArgumentException(String.format("The total bandwidth can't support such decrease %s",
                    newTotalBandwidth));
        }
        this.totalBandwidth = newTotalBandwidth;
    }
}
