package edu.ucc.core.transport.links;

import edu.ucc.network.devices.Host;

/***
 * This class models the physical link between two given devices (one direction, hence, HalfDuplex).
 * It also models the available bandwidth and methods for increasing or decreasing it.
 */
public class HalfDuplexLink extends Link {
    private Host origin;
    private Host destination;

    public HalfDuplexLink(Host origin, Host destination, double totalBandwidth) {
        this.origin = origin;
        this.destination = destination;
        this.totalBandwidth = totalBandwidth;
        this.availableBandwidth = totalBandwidth;
    }

    public Host getOrigin() {
        return origin;
    }

    public void setOrigin(Host origin) {
        this.origin = origin;
    }

    public Host getDestination() {
        return destination;
    }

    public void setDestination(Host destination) {
        this.destination = destination;
    }
}
