package edu.ucc.core.simpleimplementations;

import edu.ucc.core.HandoverManager;
import edu.ucc.core.Simulation;
import edu.ucc.core.events.simulationevents.HandoverEvent;
import edu.ucc.core.transport.chunks.ContentChunk;
import edu.ucc.network.devices.*;

import java.util.List;

import static edu.ucc.utils.TransmissionUtils.fuseListsOfChunks;

public class SimpleCloudHandoverManager implements HandoverManager {
    private int i = 0;

    @Override
    public void onUserEquipmentHandover(Host host, HandoverEvent handoverEvent) {
        final CloudUnit cloudUnit = (CloudUnit) host;
        final BaseStation targetBS = handoverEvent.getTargetBS();
        final UserEquipment movingUE = handoverEvent.getMovingUE();
        if (handoverEvent.isIntraHandover()) {
            throw new RuntimeException("[HandoverEvent] At Cloud, UE would be under the same ES, nothing to change. " +
                    "This should not be handled here.");
        } else {
            // if the target BS is in another Edge Server, then
            EdgeServer targetES = cloudUnit.findEdgeServerForBS(targetBS);
            cloudUnit.updateEdgeServerPartInRoutingTable(movingUE, targetES);

            // First strategy, retransmit everything that didn't arrive to UE
            final List<ContentChunk> pendingChunksInCloud = cloudUnit.getPendingChunksForUE(movingUE.getId());
            final List<ContentChunk> pendingAckChunksInCloud = cloudUnit.getPendingAckChunksForUE(movingUE.getId());

            cloudUnit.removePendingChunksForMovingUE(movingUE);
            cloudUnit.removeChunksWaitingAckForMovingUE(movingUE);

            final List<ContentChunk> pendingChunksInSourceES = handoverEvent.getPendingChunksInHost();
            final List<ContentChunk> pendingAckChunksInSourceES = handoverEvent.getPendingAckChunksInHost();

            final List<ContentChunk> chunksToRetransmit = fuseListsOfChunks(pendingAckChunksInSourceES,
                    pendingChunksInSourceES,
                    pendingChunksInCloud,
                    pendingAckChunksInCloud);

            cloudUnit.reSendChunksFromSourceES(targetES, chunksToRetransmit);
//            System.out.println(String.format("Handover %s at cloud", (i++)));
            Simulation.getInstance().getEventsBroker().onUserEquipmentHandover(cloudUnit, handoverEvent);
        }
    }
}
