package edu.ucc.core.simpleimplementations;

import edu.ucc.core.HandoverManager;
import edu.ucc.core.events.simulationevents.HandoverEvent;
import edu.ucc.core.transport.chunks.ContentChunk;
import edu.ucc.network.devices.*;

import java.util.List;

public class SimpleBaseStationHandoverManager implements HandoverManager {
    @Override
    public void onUserEquipmentHandover(Host host, HandoverEvent handoverEvent) {
        final UserEquipment movingUE = handoverEvent.getMovingUE();
        final BaseStation sourceBS = handoverEvent.getSourceBS();
        final BaseStation targetBS = handoverEvent.getTargetBS();
        final LocationFix locationFix = handoverEvent.getLocationFix();
        final List<ContentChunk> pendingChunksInHost = sourceBS.getPendingChunksForUE(movingUE.getId());
        final List<ContentChunk> pendingAckChunksInHost = sourceBS.getPendingAckChunksForUE(movingUE.getId());

        // This controls the re-assignment of bandwidth
        sourceBS.deleteChild(movingUE);
        targetBS.appendChild(movingUE);

        // The sourceBS is the way to know a change from Edge Server
        final EdgeServer edgeServer = (EdgeServer) sourceBS.getParentUnit();
        final double timestamp = handoverEvent.getTimestamp();
        HandoverEvent newHandoverEvent = new HandoverEvent(sourceBS, edgeServer, timestamp, sourceBS, targetBS, movingUE,
                pendingChunksInHost, pendingAckChunksInHost, locationFix);
        sourceBS.removeChunksWaitingAckForMovingUE(movingUE);
        sourceBS.removePendingChunksForMovingUE(movingUE);

        // Again, only time we call directly a host to process an event
        edgeServer.processEvent(newHandoverEvent);
    }
}
