package edu.ucc.core.events.simulationevents;

import edu.ucc.core.Simulation;
import edu.ucc.entities.Content;
import edu.ucc.network.devices.Host;

public abstract class RequestEvent extends ObservableTestbedEvent {
    protected int requestId;
    protected final Content referredContent;

    public RequestEvent(int appId, Host eventOriginHost, Host eventDestinationHost, double timestamp,
                        Content referredContent) {
        super(appId, eventOriginHost, eventDestinationHost, timestamp);
        this.requestId = Simulation.REQUEST_ID++;
        this.referredContent = referredContent;
    }

    public RequestEvent(int requestId, int appId, Host eventOriginHost, Host eventDestinationHost, double timestamp,
                        Content referredContent) {
        super(appId, eventOriginHost, eventDestinationHost, timestamp);
        this.requestId = requestId;
        this.referredContent = referredContent;
    }

    public int getRequestId() {
        return requestId;
    }

    public Content getReferredContent() {
        return referredContent;
    }

    public abstract Host getContentLocationHost();

    /**
     * Returns the "logical" destination host for the transmitted content.
     * If it is a push request type, it will return the pushDestinationHost. If it is a pull request type, it will
     * return the pullInitiatorHost (a.k.a requestingHost).
     *
     * @return The destination for the content that will be transmitted to fulfill this request.
     */
    public abstract Host getContentDestinationHost();

    @Override
    public String toString() {
        String destinationAsStr = "Null destination";
        int destinationId = -1;
        if (eventDestinationHost != null) {
            destinationAsStr = eventDestinationHost.getTypeAsString();
            destinationId = eventDestinationHost.getId();
        }

        String contentAsStr = referredContent == null ?
                "--" : referredContent.getURI();

        if (eventOriginHost != null) {
            String originAsStr = eventOriginHost.getTypeAsString();
            int originId = eventOriginHost.getId();
            return String.format("At %s %s, from %s %s for content %s, @%.14f", destinationAsStr,
                    destinationId, originAsStr, originId, contentAsStr, timestamp);
        } else {
            return String.format("At %s %s, for content %s, @%.14f", destinationAsStr,
                    destinationId, contentAsStr, timestamp);
        }
    }
}
