package edu.ucc.core.events.simulationevents;

import edu.ucc.entities.Content;
import edu.ucc.network.devices.Host;

public abstract class PushRequestEvent extends RequestEvent {
    protected final Host pushInitiatorHost;
    protected final Host pushDestinationHost;
    protected final PushReason pushReason;

    public PushRequestEvent(int appId, Host eventOriginHost, Host eventDestinationHost, double timestamp,
                            Host pushInitiatorHost, Host pushDestinationHost, Content referredContent, PushReason pushReason) {
        super(appId, eventOriginHost, eventDestinationHost, timestamp, referredContent);
        this.pushInitiatorHost = pushInitiatorHost;
        this.pushDestinationHost = pushDestinationHost;
        this.pushReason = pushReason;
    }

    public PushRequestEvent(int requestId, int appId, Host eventOriginHost, Host eventDestinationHost, double timestamp,
                            Host pushInitiatorHost, Host pushDestinationHost, Content referredContent, PushReason pushReason) {
        super(requestId, appId, eventOriginHost, eventDestinationHost, timestamp, referredContent);
        this.pushInitiatorHost = pushInitiatorHost;
        this.pushDestinationHost = pushDestinationHost;
        this.pushReason = pushReason;
    }

    public Host getPushInitiatorHost() {
        return pushInitiatorHost;
    }

    public Host getPushDestinationHost() {
        return pushDestinationHost;
    }

    @Override
    public Host getContentLocationHost() {
        return pushInitiatorHost;
    }

    @Override
    public Host getContentDestinationHost() {
        return pushDestinationHost;
    }

    public PushReason getPushReason() {
        return pushReason;
    }
}

