package edu.ucc.core.events.simulationevents;

import edu.ucc.entities.File;
import edu.ucc.network.devices.CloudUnit;
import edu.ucc.network.devices.Host;
import edu.ucc.network.devices.UserEquipment;

public final class PullFileRequestEvent extends PullRequestEvent {

    public PullFileRequestEvent(int appId, Host eventOriginHost, Host eventDestinationHost, double timestamp,
                                UserEquipment requestingUE, CloudUnit cloudUnit, File referredFile) {
        super(appId, eventOriginHost, eventDestinationHost, timestamp, requestingUE, cloudUnit, referredFile);
    }

    public PullFileRequestEvent(int requestId, int appId, Host eventOriginHost, Host eventDestinationHost, double timestamp,
                                UserEquipment requestingUE, CloudUnit cloudUnit, File referredFile) {
        super(requestId, appId, eventOriginHost, eventDestinationHost, timestamp, requestingUE, cloudUnit, referredFile);
    }


    @Override
    public CloudUnit getPullDestinationHost() {
        return (CloudUnit) super.getPullDestinationHost();
    }

    @Override
    public UserEquipment getPullInitiatorHost() {
        return (UserEquipment) super.getPullInitiatorHost();
    }

    @Override
    public PullFileRequestEvent createEventForNextHop(Host nextHopHost, double timeToReachHost) {
        double eventTime = this.getTimestamp();
        double timestamp = eventTime + timeToReachHost;
        final Host originHost = this.getEventDestinationHost();
        final CloudUnit cloud = this.getPullDestinationHost();
        final int requestId = this.getRequestId();
        final int appId = this.getAppId();
        final UserEquipment requestingUE = getPullInitiatorHost();
        final File referredFile = getReferredContent();

        return new PullFileRequestEvent(requestId, appId, originHost, nextHopHost, timestamp, requestingUE,
                cloud, referredFile);
    }

    @Override
    public File getReferredContent() {
        return (File) super.getReferredContent();
    }

    @Override
    public String toString() {
        return "[PullFileRequestEvent] " + super.toString();
    }
}
