package edu.ucc.core.events.simulationevents;

import edu.ucc.core.transport.chunks.ContentChunk;
import edu.ucc.network.devices.BaseStation;
import edu.ucc.network.devices.Host;
import edu.ucc.network.devices.LocationFix;
import edu.ucc.network.devices.UserEquipment;

import java.util.List;

import static edu.ucc.core.events.simulationevents.EventsConstants.SYSTEM_APP_ID;

public final class HandoverEvent extends ObservableTestbedEvent {
    private final UserEquipment movingUE;
    private final BaseStation sourceBS;
    private final BaseStation targetBS;
    private final LocationFix locationFix;
    private final List<ContentChunk> pendingAckChunksInHost;
    private final List<ContentChunk> pendingChunksInHost;

    public HandoverEvent(Host originHost, Host destinationHost, double timestamp, BaseStation sourceBS,
                         BaseStation targetBS, UserEquipment movingUE, List<ContentChunk> pendingChunksInHost,
                         List<ContentChunk> pendingAckChunksInHost, LocationFix locationFix) {
        super(SYSTEM_APP_ID, originHost, destinationHost, timestamp);
        this.sourceBS = sourceBS;
        this.targetBS = targetBS;
        this.movingUE = movingUE;
        this.pendingChunksInHost = pendingChunksInHost;
        this.pendingAckChunksInHost = pendingAckChunksInHost;
        this.locationFix = locationFix;
    }

    public BaseStation getTargetBS() {
        return targetBS;
    }

    public BaseStation getSourceBS() {
        return sourceBS;
    }

    public UserEquipment getMovingUE() {
        return movingUE;
    }

    public List<ContentChunk> getPendingChunksInHost() {
        return pendingChunksInHost;
    }

    public List<ContentChunk> getPendingAckChunksInHost() {
        return pendingAckChunksInHost;
    }

    public boolean isIntraHandover() {
        return targetBS.getParentUnit() == sourceBS.getParentUnit();
    }

    @Override
    public String toString() {
        return "HO{" +
                "UE=" + movingUE.getId() +
                ", sourceBS=" + sourceBS.getId() +
                ", targetBS=" + targetBS.getId() +
                ", pendingChunksInHost=" + (pendingChunksInHost == null ? "0" : pendingChunksInHost.size()) +
                ", ts=" + timestamp +
                "} ";
    }

    public LocationFix getLocationFix() {
        return locationFix;
    }
}


