package edu.ucc.core.events.simulationevents;

import edu.ucc.entities.Content;
import edu.ucc.network.devices.Host;

public final class ContentReceivedEvent extends ObservableTestbedEvent {
    private final int requestId;
    private final RequestEvent originalRequestEvent;
    private final Content referredContent;

    public ContentReceivedEvent(Host eventOriginHost, Host eventDestinationHost, double timestamp,
                                int appId, int requestId, Content referredContent, RequestEvent originalRequestEvent) {
        super(appId, eventOriginHost, eventDestinationHost, timestamp);
        this.requestId = requestId;
        this.referredContent = referredContent;
        this.originalRequestEvent = originalRequestEvent;
    }

    public Content getReferredContent() {
        return referredContent;
    }

    public RequestEvent getOriginalRequestEvent() {
        return originalRequestEvent;
    }

    @Override
    public String toString() {
        final Host host = getEventDestinationHost();
        return String.format("At %s %s, received %s from %s %s @ %s", host.getTypeAsString(),
                host.getId(),
                referredContent.getDescription(),
                eventOriginHost.getTypeAsString(),
                eventOriginHost.getId(),
                getTimestamp());
    }
}
