package edu.ucc.core.events.simulationevents;

import edu.ucc.core.transport.chunks.ContentChunk;
import edu.ucc.network.devices.Host;

public final class AckReceivedEvent extends TestbedEvent {
    private final ContentChunk contentChunk;

    public AckReceivedEvent(Host originHost, Host destinationHost, double timestamp, ContentChunk contentChunk) {
        super(originHost, destinationHost, timestamp);
        this.contentChunk = contentChunk;
    }

    public ContentChunk getContentChunk() {
        return contentChunk;
    }

    @Override
    public String toString() {
        ContentChunk chunk = getContentChunk();
        return String.format("At %s %s: ACK for chunk %s/%s for request %s received from %s %s, @ %s",
                eventDestinationHost.getTypeAsString(), eventDestinationHost.getId(),
                chunk.getChunkNumber(), chunk.getTotalChunks() - 1, chunk.getRequestEvent().getRequestId(),
                eventOriginHost.getTypeAsString(), eventOriginHost.getId(), getTimestamp());
    }
}

