package edu.ucc.core;

import edu.ucc.core.events.simulationevents.PrefetchRequestEvent;
import edu.ucc.network.devices.Host;

public interface PrefetchManager {
    /**
     * Functionality to implement by a host whenever a request for prefetching content is received.
     * At the moment only the cloud is allowed to serve these requests.
     * @param host The host receiving the event.
     * @param prefetchRequestEvent The event reference.
     */
    void onPrefetchRequestReceived(Host host, PrefetchRequestEvent prefetchRequestEvent);
}
