package edu.ucc.core;

import edu.ucc.core.events.simulationevents.AckReceivedEvent;
import edu.ucc.core.events.simulationevents.ChunkReceivedEvent;
import edu.ucc.core.events.simulationevents.PullRequestEvent;
import edu.ucc.core.events.simulationevents.PushRequestEvent;
import edu.ucc.network.devices.Host;

/**
 * Interface for specifying how the movement of data should be performed across the network hierarchy
 * for content requests.
 */
public interface ContentTransmitter {
    /**
     * Functionality to perform when a request content event is received.
     *
     * @param host             The host handling the event.
     * @param pullRequestEvent The event reference.
     */
    void onPullRequestReceived(Host host, PullRequestEvent pullRequestEvent);

    /**
     * Functionality to perform by the host when an ACK corresponding to a sent ContentChunk is received from a host.
     *
     * @param host             The host handling the event.
     * @param ackReceivedEvent The event reference.
     */
    void onAckReceived(Host host, AckReceivedEvent ackReceivedEvent);

    /**
     * Functionality to perform when a host receives a chunk.
     *
     * @param host               The host handling the event.
     * @param chunkReceivedEvent The event reference.
     */
    void onChunkReceived(Host host, ChunkReceivedEvent chunkReceivedEvent);

    /**
     * Functionality to perform when a host initiates/receives a push request.
     *
     * @param host             The host handling the event.
     * @param pushRequestEvent The event reference
     */
    void onPushRequestReceived(Host host, PushRequestEvent pushRequestEvent);
}
