package core.processingchain.metadata.extractor;

import core.app.App;
import core.processingchain.metadata.pool.AppMetadata;
import core.processingchain.metadata.pool.BaseMetadata;

public class AppMetadataExtractor extends MetadataExtractor<App> {
    @Override
    public BaseMetadata extractMetadata(App app) {
        return new AppMetadata(
                app.getAppId(),
                app.getName(),
                app.getUriBase(),
                app.getTotalSpace(),
                app.getPreProcessors(),
                app.getEventDetectors(),
                app.getPolicies()
        );
    }
}
