package core.processingchain.events;

import core.processingchain.metadata.pool.SolutionEventMetadata;
import core.processingchain.preprocessors.PPOutcome;
import edu.ucc.entities.Content;
import edu.ucc.network.devices.Host;

public class ApplicationEvent extends SolutionEvent {
    public ApplicationEvent(int appId, String name, Host detectingHost, PPOutcome ppOutcome,
                            SolutionEventMetadata solutionEventMetadata, double timestamp, Content referredContent) {
        super(appId, name, detectingHost, ppOutcome, solutionEventMetadata, timestamp, referredContent);
    }

    public ApplicationEvent(SolutionEvent appEvent, double eventTimestamp) {
        super(appEvent.getAppId(), appEvent.getName(), appEvent.getDetectingHost(), appEvent.getPpOutcome(),
                (SolutionEventMetadata) appEvent.getMetadata(), eventTimestamp, appEvent.getReferredContent());

    }
}
