package core.processingchain.actions.pool;

import core.app.App;
import core.processingchain.actions.InternalAction;
import core.processingchain.actions.exceptions.AppOutOfStorageException;
import core.processingchain.actions.exceptions.HostOutOfStorageException;
import core.processingchain.actions.exceptions.SolutionException;
import core.processingchain.actions.policies.BasePolicy;
import core.processingchain.events.SolutionEvent;
import edu.ucc.entities.Content;
import edu.ucc.network.devices.Host;

import static edu.ucc.utils.Logging.printDebug;
import static edu.ucc.utils.Logging.printError;

public class StoreAction extends InternalAction {
    public StoreAction() {
        super("StoreAction");
    }

    @Override
    public void execute(App app, Host localHost, SolutionEvent solutionEvent, BasePolicy policy) throws SolutionException {
        // final Host localHost = solutionEvent.getDetectingHost();
        final Content content = solutionEvent.getReferredContent();
        final double timestamp = solutionEvent.getTimestamp();

        printDebug(String.format("StoreAction: storing content %s in ES %s", content.getDescription(),
                localHost.getId()));
        try {
            app.storeLocalPopularContent(localHost, content, timestamp);
        } catch (AppOutOfStorageException | HostOutOfStorageException e) {
            printError(e.getMessage());
            throw new SolutionException(this, e.getMessage(), e);
        }
    }
}
