package core.processingchain.actions.pool;

import core.app.App;
import core.control.AppMessageData;
import core.control.PushMessageRequestEvent;
import core.processingchain.actions.ExternalAction;
import core.processingchain.actions.policies.BasePolicy;
import core.processingchain.events.ApplicationEvent;
import core.processingchain.events.SolutionEvent;
import core.processingchain.events.pool.NotificationEvent;
import edu.ucc.core.Simulation;
import edu.ucc.network.devices.EdgeServer;
import edu.ucc.network.devices.Host;

import java.util.List;

import static edu.ucc.utils.Logging.printInfo;

public class NotificationAction extends ExternalAction {
    public NotificationAction() {
        super("NotificationAction");
    }

    @Override
    public void execute(App app, Host localHost, SolutionEvent solutionEvent, BasePolicy policy) {
        final List<String> subscribers = app.getExternalSubscribersPerEventType(solutionEvent.getClass());
        String sb = String.join(", ", subscribers);
        if (localHost instanceof EdgeServer) {
            printInfo(String.format("NotificationAction: Advising cloud to notify external subscribers %s", sb));
            final PushMessageRequestEvent pushRequestEvent = createPushMessageRequestEvent(solutionEvent, localHost, subscribers);
            Simulation.getInstance().postEvent(pushRequestEvent);
        }else{
            printInfo(String.format("The event data is already on the cloud, notifying subscribers %s", sb));
        }
    }

    private PushMessageRequestEvent createPushMessageRequestEvent(SolutionEvent solutionEvent, Host localHost, List<String> subscribers) {
         final EdgeServer edgeServer = (EdgeServer) localHost;
        ApplicationEvent asAppEvent = (ApplicationEvent) solutionEvent;
        final double notificationEventTimestamp = asAppEvent.getTimestamp();
        NotificationEvent notificationEvent = new NotificationEvent(asAppEvent, subscribers, notificationEventTimestamp);
        long size = subscribers.stream().mapToLong(String::length).sum() * 8;
        AppMessageData appMessageData = new AppMessageData(size, notificationEventTimestamp, notificationEvent);
        final double notificationEventGenerationDelay = 0.000015;

        return new PushMessageRequestEvent(
                solutionEvent.getAppId(),
                null,
                edgeServer,
                notificationEventTimestamp + notificationEventGenerationDelay,
                appMessageData,
                edgeServer,
                edgeServer.getParentUnit()
        );
    }
}
