package core.processingchain.actions.policies.pool;

import core.processingchain.actions.policies.BasePolicy;

public class PushPolicy extends BasePolicy {
    private final boolean pushToParent;
    private final boolean pushToNeighbors;
    private final boolean pushToChildren;

    public PushPolicy(boolean pushToParent, boolean pushToNeighbors, boolean pushToChildren) {
        this.pushToParent = pushToParent;
        this.pushToNeighbors = pushToNeighbors;
        this.pushToChildren = pushToChildren;
    }

    public boolean isPushToParent() {
        return pushToParent;
    }

    public boolean isPushToNeighbors() {
        return pushToNeighbors;
    }

    public boolean isPushToChildren() {
        return pushToChildren;
    }
}
