package core.processingchain.actions.exceptions;

import core.processingchain.actions.BaseAction;

public class SolutionException extends Exception {
    private final BaseAction action;
    private final SystemException innerException;


    public SolutionException(BaseAction action, String message, SystemException innerException) {
        super(message);
        this.action = action;
        this.innerException = innerException;
    }

    public String getDescription() {
        return String.format("Exception %s occurred when executing action %s (%s)",
                innerException.getClass().getSimpleName(),
                action.getName(),
                getMessage());
    }
}
